//LabPlot : FunctionDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>

#ifdef HAVE_SOLARIS
#include <ieeefp.h>
#endif

#include <qlabel.h>
#include <qhbox.h>
#include <qcolordialog.h>
#include <qprogressdialog.h>
#include <qtabwidget.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include "FunctionDialog.h"
#include "Plot2DSurface.h"
#include "PlotQWT3D.h"
#include "defs.h"

#ifdef HAVE_GSL
#include <gsl/gsl_errno.h>
#include <gsl/gsl_math.h>
#endif

#include "parser_struct.h"
extern "C" con constants[];
extern "C" init arith_fncts[];
#include "parser_extern.h"

using namespace std;

/*! newtype -> new 3D Plot type*/
FunctionDialog::FunctionDialog(MainWin *m, const char *name, ListDialog *l, int it, PType newtype)
	: Dialog(m, name), l(l), item(it)
{
	kdDebug()<<"FunctionDialog()"<<endl;
	Plot *plot=0;
	if(p != 0)
	 	plot = p->getPlot(p->API());
	type = newtype;

	kdDebug()<<"FunctionDialog : plot type = "<<type<<endl;

	QString caption;
	if (type == P2D)
		caption=i18n("2D Function Dialog");
	else if (type == P3D)
		caption=i18n("3D Function Dialog");
	else if (type == PQWT3D)
		caption=i18n("3D QWT Function Dialog");
	else if (type == PSURFACE)
		caption=i18n("2D Surface Function Dialog");
	else if (type == PPOLAR)
		caption=i18n("2D Polar Function Dialog");
	caption += i18n(" : ")+QString(name);
	setCaption(caption);

	Style *style=0;
	Symbol *symbol=0;
	LRange rx, ry;
	GRAPHType st = GRAPH2D;
	int nrx = 0, nry = 0;

	if(type == PPOLAR) {
		if(symbol) symbol->setType(SCROSS);
	}

	kdDebug()<<"get values"<<endl;
	// default style and symbol for polar plots
	if (item == -1) {	// new graph
		graph = 0;
	}
	else {
		GraphList *gl = plot->getGraphList();
		graph = gl->getGraph(item);
		st = gl->getType(item);

		style = graph->getStyle();
		symbol = graph->getSymbol();
		kdDebug()<<"Struct : "<<st<<endl;

		if (st == GRAPH2D) {
			Graph2D *g = gl->getGraph2D(item);
			rx = g->Range(0);
			nrx = graph->Number();
		}
		else if (st == GRAPH3D) {
			Graph3D *g = gl->getGraph3D(item);
			rx = g->Range(0);
			ry = g->Range(1);
			nrx = g->NX();
			nry = g->NY();
		}
		else if (st == GRAPHM) {
			GraphM *g = gl->getGraphM(item);
			rx = g->Range(0);
			ry = g->Range(1);
			nrx = g->NX();
			nry = g->NY();
		}
	}

	kdDebug()<<"build widgets"<<endl;
	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	// constants/function comboboxes
	QHBox *hb = new QHBox(tab1);
	QLabel *conlabel = new QLabel(i18n("Constants :"),hb);
	concb = new KComboBox(hb);
	int f=0;
	QString tmp=0;
	while(true){
		tmp = constants[f++].name;
		if(tmp.isEmpty())
			break;
		concb->insertItem(tmp);
	};
	QObject::connect(concb,SIGNAL(activated(int)),SLOT(insertConstant(int)));

	hb = new QHBox(tab1);
	QLabel *sellabel = new QLabel(i18n("Functions :"),hb);
	selcb = new KComboBox(hb);
	f=0;
	while(true){
		tmp = arith_fncts[f++].fname;
		if(tmp.isEmpty())
			break;
		selcb->insertItem(tmp+"()");
	}
	QObject::connect(selcb,SIGNAL(activated(int)),SLOT(insertFunction(int)));

	KConfig *config = mw->Config();
	config->setGroup( "Function" );

	QString entry = QString("PlotType %1 ").arg(type);

	// hide them; shown later if necessary
	concb->hide();
	conlabel->hide();
	selcb->hide();
	sellabel->hide();

	// function
	QString fun("sin(x)");
	if (type == P3D || type == PSURFACE || type == PQWT3D)
		fun = QString("sin(x+y)");
	if (graph != 0) fun = graph->Name();
	else fun = config->readEntry(entry+"Function",fun);

	new QLabel(i18n("Function :"),tab1);
	funle = new KLineEdit(fun,tab1);
	if (graph != 0 && graph->Source() == SSPREADSHEET)
		funle->setReadOnly(true);

	hb = new QHBox(tab1);
	reread = 0;
	if (graph == 0 || (graph != 0 && graph->Source() == SFUNCTION)) {
		conlabel->show();
		concb->show();
		sellabel->show();
		selcb->show();
		reread = new QCheckBox(i18n("Recreate Function"),hb);
		reread->setChecked(true);
	}
	if (graph == 0 )	// don't show for new function
		reread->hide();

	KPushButton *setLabel = new KPushButton(i18n("Update Label"),hb);
	QObject::connect(setLabel,SIGNAL(clicked()),SLOT(updateLabel()));

	hb = new QHBox(tab1);
	new QLabel(i18n("Range : "),hb);

	double x1 = config->readDoubleNumEntry(entry+"XMin",0);
	double x2 = config->readDoubleNumEntry(entry+"XMax",1);
	if (graph != 0) {
		x1 = rx.rMin();
		x2 = rx.rMax();
	}
	xmin = new KLineEdit(QString::number(x1),hb);
	new QLabel(QString(" .. "),hb);
	xmax = new KLineEdit(QString::number(x2),hb);
	ymin=ymax=0;
	if (type == P3D || type == PSURFACE || type == PQWT3D) {
		new QLabel(QString(" y = "),hb);

		double y1 = config->readDoubleNumEntry(entry+"YMin",0);
		double y2 = config->readDoubleNumEntry(entry+"YMax",1);
		if (graph != 0) {
			x1 = rx.rMin();
			x2 = rx.rMax();
			y1 = ry.rMin();
			y2 = ry.rMax();
		}
		ymin = new KLineEdit(QString::number(y1),hb);
		new QLabel(QString(" .. "),hb);
		ymax = new KLineEdit(QString::number(y2),hb);
	}
	hb = new QHBox(tab1);
	new QLabel(i18n("Number of Points :"),hb);
	nx=0;		// needed for spreadsheet graph later
	ny=0;
	if(type == P2D || type == PPOLAR) {
		if (graph == 0) nrx = config->readNumEntry("NX",100);
		nx = new KIntNumInput(nrx,hb);
		nx->setMinValue(1);
	}
	else if (type == P3D || type == PSURFACE || type == PQWT3D){
		if (graph == 0) {
			nrx = config->readNumEntry("NX",100);
			nry = config->readNumEntry("NY",100);
		}
		nx = new KIntNumInput(nrx,hb);
		nx->setMinValue(1);
		new QLabel(QString("NY = "),hb);
		ny = new KIntNumInput(nry,hb);
		ny->setMinValue(1);
	}

	if (graph != 0 && graph->Source() == SSPREADSHEET) {
		xmin->setEnabled(false);
		xmax->setEnabled(false);
		if(nx) nx->setEnabled(false);
		if(ny) ny->setEnabled(false);
	}

	QVBox *tab2 = new QVBox(tw);
	Label* label = new Label(config->readEntry(entry+"Function",fun));
	if (graph != 0) {
		delete label;
		label = graph->getLabel();
	}
	rtw = new RichTextWidget((QWidget *)tab2,label,0);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(tab2,i18n("Label"));

	QVBox *styletab, *annotatetab, *errorbartab;
	if (type == PSURFACE) {
		styletab = surfaceStyle(tw,item==-1?true:false);
		tw->addTab(styletab,i18n("Style"));
	}
	else if (type != PQWT3D) {
		styletab = simpleStyle(tw, style, symbol);
		annotatetab = annotateValuesTab(tw,graph);
		errorbartab = errorbarTab(tw,symbol);
		tw->addTab(styletab,i18n("Style"));
		tw->addTab(annotatetab,i18n("Annotate Values"));
		tw->addTab(errorbartab,i18n("Errorbars"));
	}

	kdDebug()<<"build destinations"<<endl;
	// result selection
	hb = new QHBox(vbox);
	new QLabel(i18n("add result to "),hb);
	sheetcb = new KComboBox(hb);
	QStringList wlist;
	QWidgetList list = mw->getWorkspace()->windowList();
	for(unsigned int i=0;i<list.count();i++)
		wlist << list.at(i)->caption();
	wlist<<i18n("new Worksheet")<<i18n("new Spreadsheet");
	sheetcb->insertStringList(wlist);
	sheetcb->setCurrentItem(mw->activeSheetIndex());

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize((int)(1.2*minimumSize().width()),minimumSize().height());

	kdDebug()<<"FunctionDialog() DONE"<<endl;
}

FunctionDialog::~FunctionDialog() {
	delete rtw;
}

void FunctionDialog::saveSettings(bool pressed) {
	kdDebug()<<"FunctionDialog::saveSettings("<<pressed<<")"<<endl;
	KConfig *config = mw->Config();
	config->setGroup( "Function" );

	QString entry = QString("PlotType %1 ").arg(type);

	config->writeEntry(entry+"Function",funle->text());
	// TODO : not used config->writeEntry(entry+"Reread",reread->isChecked());
	config->writeEntry(entry+"XMin",xmin->text().toDouble());
	config->writeEntry(entry+"XMax",xmax->text().toDouble());
	if(ymin != 0 && ymax != 0) {
		config->writeEntry(entry+"YMin",ymin->text().toDouble());
		config->writeEntry(entry+"YMax",ymax->text().toDouble());
	}
	config->writeEntry(entry+"NX",nx->value());
	if(ny != 0)
		config->writeEntry(entry+"NY",ny->value());

	if(! pressed)
		return;

	rtw->getLabel()->saveSettings(config,entry);

	if(type == PSURFACE)
		saveSurfaceStyle();

	if(type != PQWT3D && type != PSURFACE) {
		if(typecb)
			config->writeEntry(entry+"Annotate Type",typecb->currentItem());
		if(positioncb)
			config->writeEntry(entry+"Annotate Position",positioncb->currentItem());
		if(distance)
			config->writeEntry(entry+"Annotate Distance",distance->value());

		saveErrorbarSettings();
	}
}

void FunctionDialog::insertConstant(int i) {
	QString text = funle->text();
	int pos = funle->cursorPosition();
	QString c = constants[i].name;
	text.insert(pos,c);
	funle->setText(text);
	funle->setCursorPosition(pos+c.length());
}

void FunctionDialog::insertFunction(int i) {
	QString text = funle->text();
	int pos = funle->cursorPosition();
	QString c = arith_fncts[i].fname;
	text.insert(pos,c+"()");
	funle->setText(text);
	funle->setCursorPosition(pos+c.length()+2);
}

// search for a usable plot; add worksheet if necessary
void FunctionDialog::findPlot() {
	kdDebug()<<"FunctionDialog::findPlot()"<<endl;
	int sitem = sheetcb->currentItem(), count = sheetcb->count();
	kdDebug()<<"	sheetcb->currentItem() = "<<sitem<<" of "<<count<<endl;

	if(sitem>=count-2)		// new sheet selected
		return;

	QWidgetList list = mw->getWorkspace()->windowList();
	p = (Worksheet *) list.at(sitem);
	if(p==0 || p->getWidgetType() != WWORKSHEET) {
		p = mw->activeWorksheet();
		return;
	}

	Plot *plot=0;
	if(p)
		plot = p->getPlot(p->API());

	if(plot && plot->Type() == PQWT3D || type == PQWT3D) {	// new worksheet if plot is qwt3d or type = qwt3d
		kdDebug()<<"	QWT Plot found! type = "<<type<<endl;
		if(plot && plot->getGraphList()->Number() > 0 ) {
			p = mw->newWorksheet();
			p->newPlot(type);
			plot = p->getPlot(p->API());
			sheetcb->setCurrentItem(count-2);		// set item to new worksheet
		}
		else
			p->newPlot(type);
	}
	else if(sitem < count-2 && plot && plot->Type() != type)		// new plot if choosen of other type.
		p->newPlot(type);					// not if already new sheet selected
}

int FunctionDialog::apply_clicked() {
	kdDebug()<<"FunctionDialog::apply_clicked()"<<endl;

	findPlot();

	// add function
	// TODO : use richtext label
//	QString label = labelle->text();
	int status=0;
	if (reread && reread->isChecked()) {
		kdDebug()<<"	reread is checked"<<endl;
		status = addFunction();
	}
	else {	// only edit function
		kdDebug()<<"	plot type = "<<type<<endl;
		if(type == PSURFACE) {
			kdDebug()<<"	surface plot"<<endl;
			if (p != 0) {
				kdDebug()<<"		p != 0 surface plot"<<endl;
				Plot2DSurface *plot = (Plot2DSurface *)p->getPlot(p->API());

				if (plot != 0) {
					kdDebug()<<"	reading settings"<<endl;
					plot->enableDensity(dcb->isChecked());
					plot->enableContour(ccb->isChecked());
					plot->setNumber(numberle->text().toInt());
					// OLD : plot->setPalette(pcb->currentItem());
					plot->setContourColor(contourcolor->color());
					plot->setColoredContour(coloredcb->isChecked());
					plot->setContourWidth(contourwidthle->text().toInt());
					plot->setMesh(meshcb->isChecked());
					plot->setRelative(relativecb->isChecked());
					plot->setBrush(dbrushcb->currentItem());
					plot->setThreshold(thresholdle->text().toDouble());
				}
			}
		}
		else {
			Style *style = new Style((StylesType)cb2->currentItem(),color->color(),filled->isChecked(),
				fcolor->color(),width->value(),pencb->currentItem(),brushcb->currentItem());
			style->setBoxWidth(boxwidth->value());
			style->setAutoBoxWidth(autobox->isChecked());
			style->setPointsSorting(sortpointscb->isChecked());
			Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
					(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
			AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distance->value());
			Errorbar *errorbar = new Errorbar(ebarcolor->color(), ebarxsize->value(), ebarysize->value(),
				(Qt::PenStyle) ebarstylecb->currentItem(), ebarwidth->value(), (EType) ebarxtypecb->currentItem(),
				(EType) ebarytypecb->currentItem(), ebarbcolor->color(), ebarbwidth->value(),
				(Qt::PenStyle) ebarbstylecb->currentItem() );
			symbol->setErrorbar(errorbar);
			graph->setStyle(style);
			graph->setSymbol(symbol);
			graph->setAnnotateValues(av);
		}
		graph->setLabel(rtw->label());
	}

	if(l) l->updateList();
	if(p) {
		p->updatePixmap();
		// update item (graphlist changes)
		item = p->getPlot(p->API())->getGraphList()->Number()-1;
	}

	return status;
}

int FunctionDialog::addFunction() {
	kdDebug()<<"FunctionDialog::addFunction()"<<endl;
	QString fun = funle->text().lower();

	fun.remove(QRegExp(".*="));		// remove any "xyz =" before expression

	// save "last" values
	saveSettings(false);

	KConfig *config = mw->Config();
	config->setGroup( "Function" );

	QString entry = QString("PlotType %1 ").arg(type);

	Label *label = rtw->getLabel();
	bool graphDeleted = false;
	QString title = label->Title();
	int NX = nx->value();
	int NY = 0;
	if (type == P3D || type == PSURFACE || type == PQWT3D)
		NY = ny->value();

	QProgressDialog progress( i18n("Creating function ..."), i18n("Cancel"), NX,this, "progress", true );
	progress.setMinimumDuration(2000);
	if (type == P2D || type == PPOLAR) {
		kdDebug()<<"	\"2d\" or \" polar \" selected"<<endl;
		Point *ptr = new Point[NX];

		double ymi=0, yma=1;
		double xmi = parse((char *) xmin->text().latin1());
		double xma = parse((char *) xmax->text().latin1());
		init_table();

		for(int i = 0;i < NX;i++) {
			if(i%100 == 0) progress.setProgress( i );
    			qApp->processEvents();

			double x = (xma-xmi)*i/(double)(NX-1)+xmi;
			char var[]="x";
			assign_variable(var,x);
//			kdDebug()<<"	parsing "<<fun.latin1()<<endl;
#ifdef HAVE_GSL
			gsl_set_error_handler_off();
#endif
			double y = parse((char *) fun.latin1());

			if(parse_errors()>0) {
				progress.cancel();
				KMessageBox::error(mw, i18n("Parse Error!\n Please check the given function."));
				delete_table();
				return 1;
			}

			bool nanvalue=false;
			if (!finite(x))	{ x=0; nanvalue=true; }
			if (!finite(y))	{ y=0; nanvalue=true; }

			if (i == 0) ymi=yma=y;
			y<ymi?ymi=y:0;
			y>yma?yma=y:0;

			ptr[i].setPoint(x,y);
			if(nanvalue)
				ptr[i].setMasked();
			if ( progress.wasCancelled() ) {
				delete_table();
				return 1;
			}
		}
		delete_table();

		if(p!=0 && graph != 0)
		  {
		        label = new Label(*rtw->getLabel());
			p->getPlot(p->API())->getGraphList()->delGraph(item);
			graphDeleted = true;
		  }

		if(yma-ymi == 0) {
			ymi -= 1;
			yma += 1;
		}

		if(type == PPOLAR) {
			xmi = 0;
			xma = 2*M_PI;
		}

		LRange range[2];
		range[0] = LRange(xmi,xma);
		range[1] = LRange(ymi,yma);
		Style *style = new Style((StylesType)cb2->currentItem(),color->color(),filled->isChecked(),
			fcolor->color(),width->value(),
			pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());

		kdDebug()<<"	range[0]="<<range[0].rMin()<<","<<range[0].rMax()<<endl;
		kdDebug()<<"	range[1]="<<range[1].rMin()<<","<<range[1].rMax()<<endl;

		Graph2D *g = new Graph2D(fun,title,range,SFUNCTION,type,style,symbol,ptr,NX);
		g->setLabel(label);
		kdDebug()<<"	label->isTeXLabel() : "<<label->isTeXLabel()<<endl;

		AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distance->value());
		g->setAnnotateValues(av);
		mw->addGraph2D(g,sheetcb->currentItem(),type);
	}
	else if (type == PSURFACE || type == PQWT3D) {
		kdDebug()<<"	\"surface\" or \" qwt 3d \" selected"<<endl;
		kdDebug()<<"	NX = "<<NX<<"/ NY = "<<NY<<endl;

		double *a = new double[NY*NX];

		double xmi=0, xma=1, ymi=0, yma=1, zmin=0, zmax=1;
		xmi = parse((char *) (xmin->text()).latin1());
		xma = parse((char *) (xmax->text()).latin1());
		ymi = parse((char *) (ymin->text()).latin1());
		yma = parse((char *) (ymax->text()).latin1());
		init_table();

		for (int i=0;i<NY;i++) {
			if(i%10==0)progress.setProgress( i );
    			qApp->processEvents();
			char var[]="y";
			assign_variable(var,(yma-ymi)*i/(double)(NY-1)+ymi);

			for (int j=0;j<NX;j++) {
				var[0]='x';
				assign_variable(var,(xma-xmi)*j/(double)(NX-1)+xmi);
#ifdef HAVE_GSL
			gsl_set_error_handler_off();
#endif
				double z = parse((char *) fun.latin1());

				if(parse_errors()>0) {
					progress.cancel();
					KMessageBox::error(mw, i18n("Parse Error!\n Please check the given function."));
					delete_table();
					return 1;
				}

				bool nanvalue=false;
				if (!finite(z)) { z=0; nanvalue=true; }

				//kdDebug()<<"z = "<<z<<" (i/j = "<<i<<'/'<<j<<")\n";

				if (i == 0 && j == 0) {
					zmin=z;
					zmax=z;
				}

				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;

				a[j+NX*i] = z;
				// TODO : mask if nanvalue
			}
			if ( progress.wasCancelled() ) {
				delete_table();
				return 1;
			}
		}
		delete_table();

		if(p==0) kdDebug()<<"	p==0"<<endl;
		if( p!=0 && type == PSURFACE) {
			kdDebug()<<"	p!=0 && type == PSURFACE"<<endl;
			Plot2DSurface *plot = (Plot2DSurface *)p->getPlot(p->API());

			// edit graph
			if(graph != 0)
			  {
 			        label = new Label(*rtw->getLabel());
				plot->getGraphList()->delGraph(item);
				graphDeleted = true;
			  }

			if (plot != 0) {
				kdDebug()<<"	plot!=0"<<endl;
				kdDebug()<<"	reading settings"<<endl;
				plot->enableDensity(dcb->isChecked());
				plot->enableContour(ccb->isChecked());
				plot->setNumber(numberle->text().toInt());
				// OLD : plot->setPalette(pcb->currentItem());
				plot->setContourColor(contourcolor->color());
				plot->setColoredContour(coloredcb->isChecked());
				plot->setContourWidth(contourwidthle->text().toInt());
				plot->setMesh(meshcb->isChecked());
				plot->setRelative(relativecb->isChecked());
				plot->setBrush(dbrushcb->currentItem());
				plot->setThreshold(thresholdle->text().toDouble());
			}
		}
		else if (type == PQWT3D) {
			kdDebug() << "\"qwt 3d \" selected"<<endl;
			// TODO
			//PlotQWT3D *plot = (PlotQWT3D *)p->getPlot(p->API());
		}

		if(zmax-zmin == 0) {
			zmin -= 1;
			zmax += 1;
		}

		LRange range[3];
		// old : used 0..NX,0..NY
		// new : use range
		range[0] = LRange(xmi,xma);
		range[1] = LRange(ymi,yma);
		range[2] = LRange(zmin,zmax);

		kdDebug()<<"zmin : "<<zmin<<"/ zmax : "<<zmax<<endl;
		kdDebug()<<"range : "<<range[0].rMin()<<' '<<range[0].rMax()<<endl;
		kdDebug()<<"range : "<<range[1].rMin()<<' '<<range[1].rMax()<<endl;
		kdDebug()<<"range : "<<range[2].rMin()<<' '<<range[2].rMax()<<endl;
		/*for(int i=0;i<NX;i++) {
			for(int j=0;j<NY;j++) {
				kdDebug()<<" ("<<j+NY*i<<')'<<a[j+NY*i]<<endl;
			}
			kdDebug()<<endl;
		}*/

		Style *style = new Style(LINESTYLE);
		Symbol *symbol = new Symbol(SNONE);
		GraphM *g = new GraphM(fun,title,range,SFUNCTION,type,style,symbol,a,NX,NY);
		g->setLabel(label);
		mw->addGraphM(g,sheetcb->currentItem(),type);
	}
	else if (type == P3D) {
		kdDebug() << "\"3d\" selected"<<endl;

		Point3D *ptr = new Point3D[NX*NY];

		double xmi = xmin->text().toDouble(), xma = xmax->text().toDouble();
		double ymi=(ymin->text()).toDouble(), yma=(ymax->text()).toDouble();
		double zmin=0, zmax=1;
		init_table();

		for(int i = 0;i < NY;i++) {
			if(i%100==0)progress.setProgress( i );
    			qApp->processEvents();

			double y = (yma-ymi)*i/(double)(NY-1)+ymi;
			char var[]="y";
			assign_variable(var,y);

			for (int j = 0;j < NX;j++) {
				double x = (xma-xmi)*j/(double)(NX-1)+xmi;
				var[0]='x';
				assign_variable(var,x);
#ifdef HAVE_GSL
				gsl_set_error_handler_off();
#endif
				double z = parse((char *) fun.latin1());

				if(parse_errors()>0) {
					progress.cancel();
					KMessageBox::error(mw, i18n("Parse Error!\n Please check the given function."));
					delete_table();
					return 1;
				}

				bool nanvalue=false;
				if (!finite(z)) { z=0; nanvalue=true; }

				//kdDebug()<<"z = "<<z<<endl;

				if (i == 0 && j==0 ) zmin=zmax=z;
				z<zmin?zmin=z:0;
				z>zmax?zmax=z:0;

				ptr[i*NX+j].setPoint(x,y,z);
				if(nanvalue)
					ptr[i*NX+j].setMasked();
			}
			if ( progress.wasCancelled() ) {
				delete_table();
				return 1;
			}
		}
		delete_table();

		if(graph != 0)
		  {
		        label = new Label(*rtw->getLabel());
			p->getPlot(p->API())->getGraphList()->delGraph(item);
			graphDeleted = true;
		  }

		if(zmax-zmin == 0) {
			zmin -= 1;
			zmax += 1;
		}

		LRange range[3];
		range[0] = LRange(xmi,xma);
		range[1] = LRange(ymi,yma);
		range[2] = LRange(zmin,zmax);

		kdDebug()<<"Z RANGE = "<<zmin<<' '<<zmax<<endl;

		Style *style = new Style((StylesType)cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),width->value(),
			pencb->currentItem(),brushcb->currentItem());
		style->setBoxWidth(boxwidth->value());
		style->setAutoBoxWidth(autobox->isChecked());
		style->setPointsSorting(sortpointscb->isChecked());
		Symbol *symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->value(),
				(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());

		Graph3D *g = new Graph3D(fun,title,range,SFUNCTION,P3D,style,symbol,ptr,NX,NY);
		g->setLabel(label);
		AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distance->value());
		g->setAnnotateValues(av);
		mw->addGraph3D(g,sheetcb->currentItem());
	}

	// create new label
	Label* nlabel = graphDeleted ? label : new Label(*label);
	rtw->setLabel(nlabel);

	kdDebug()<<"FunctionDialog::apply_clicked() : DONE"<<endl;
	return 0;
}
