/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIChromeRegistry.idl
 */

#ifndef __gen_nsIChromeRegistry_h__
#define __gen_nsIChromeRegistry_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIURL_h__
#include "nsIURL.h"
#endif

#ifndef __gen_nsISimpleEnumerator_h__
#include "nsISimpleEnumerator.h"
#endif

#ifndef __gen_nsISupportsArray_h__
#include "nsISupportsArray.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIChromeRegistry */
#define NS_ICHROMEREGISTRY_IID_STR "68389281-f6d0-4533-841d-344a2018140c"

#define NS_ICHROMEREGISTRY_IID \
  {0x68389281, 0xf6d0, 0x4533, \
    { 0x84, 0x1d, 0x34, 0x4a, 0x20, 0x18, 0x14, 0x0c }}

class NS_NO_VTABLE nsIChromeRegistry : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICHROMEREGISTRY_IID)

  enum { NONE = 0 };

  enum { PARTIAL = 1 };

  enum { FULL = 2 };

  /**
   * Convert a chrome URL into a canonical representation; specifically,
   *
   *   chrome://package/provider/file
   *
   * Chrome URLs are allowed to be specified in "shorthand", leaving the
   * "file" portion off. In that case, the URL is expanded to:
   *
   *   chrome://package/provider/package.ext
   *
   * where "ext" is:
   *
   *   "xul" for a "content" package,
   *   "css" for a "skin" package, and
   *   "dtd" for a "locale" package.
   *
   * @param aChromeURL the URL that is to be canonified.
   */
  /* void canonify (in nsIURI aChromeURL); */
  NS_IMETHOD Canonify(nsIURI *aChromeURL) = 0;

  /**
   * Convert a chrome URL to a "real" using the information in the registry.
   * Does not modify aChromeURL.
   *
   * @param aChromeURL the URL that is to be converted.
   */
  /* AUTF8String convertChromeURL (in nsIURI aChromeURL); */
  NS_IMETHOD ConvertChromeURL(nsIURI *aChromeURL, nsACString & _retval) = 0;

  /**
   * refresh the chrome list at runtime, looking for new packages/etc
   */
  /* void checkForNewChrome (); */
  NS_IMETHOD CheckForNewChrome(void) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICHROMEREGISTRY \
  NS_IMETHOD Canonify(nsIURI *aChromeURL); \
  NS_IMETHOD ConvertChromeURL(nsIURI *aChromeURL, nsACString & _retval); \
  NS_IMETHOD CheckForNewChrome(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICHROMEREGISTRY(_to) \
  NS_IMETHOD Canonify(nsIURI *aChromeURL) { return _to Canonify(aChromeURL); } \
  NS_IMETHOD ConvertChromeURL(nsIURI *aChromeURL, nsACString & _retval) { return _to ConvertChromeURL(aChromeURL, _retval); } \
  NS_IMETHOD CheckForNewChrome(void) { return _to CheckForNewChrome(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICHROMEREGISTRY(_to) \
  NS_IMETHOD Canonify(nsIURI *aChromeURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->Canonify(aChromeURL); } \
  NS_IMETHOD ConvertChromeURL(nsIURI *aChromeURL, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ConvertChromeURL(aChromeURL, _retval); } \
  NS_IMETHOD CheckForNewChrome(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CheckForNewChrome(); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsChromeRegistry : public nsIChromeRegistry
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICHROMEREGISTRY

  nsChromeRegistry();

private:
  ~nsChromeRegistry();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsChromeRegistry, nsIChromeRegistry)

nsChromeRegistry::nsChromeRegistry()
{
  /* member initializers and constructor code */
}

nsChromeRegistry::~nsChromeRegistry()
{
  /* destructor code */
}

/* void canonify (in nsIURI aChromeURL); */
NS_IMETHODIMP nsChromeRegistry::Canonify(nsIURI *aChromeURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String convertChromeURL (in nsIURI aChromeURL); */
NS_IMETHODIMP nsChromeRegistry::ConvertChromeURL(nsIURI *aChromeURL, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void checkForNewChrome (); */
NS_IMETHODIMP nsChromeRegistry::CheckForNewChrome()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIXULChromeRegistry */
#define NS_IXULCHROMEREGISTRY_IID_STR "f4c2e8a8-ff7b-472a-a6b7-ef0444f2a60e"

#define NS_IXULCHROMEREGISTRY_IID \
  {0xf4c2e8a8, 0xff7b, 0x472a, \
    { 0xa6, 0xb7, 0xef, 0x04, 0x44, 0xf2, 0xa6, 0x0e }}

class NS_NO_VTABLE nsIXULChromeRegistry : public nsIChromeRegistry {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IXULCHROMEREGISTRY_IID)

  /* void reloadChrome (); */
  NS_IMETHOD ReloadChrome(void) = 0;

  /* ACString getSelectedLocale (in ACString package); */
  NS_IMETHOD GetSelectedLocale(const nsACString & package, nsACString & _retval) = 0;

  /* void refreshSkins (); */
  NS_IMETHOD RefreshSkins(void) = 0;

  /* boolean allowScriptsForSkin (in nsIURI url); */
  NS_IMETHOD AllowScriptsForSkin(nsIURI *url, PRBool *_retval) = 0;

  /* void setAllowOverlaysForPackage (in wstring packageName, in boolean allowOverlays); */
  NS_IMETHOD SetAllowOverlaysForPackage(const PRUnichar *packageName, PRBool allowOverlays) = 0;

  /* void installSkin (in string baseURL, in boolean useProfile, in boolean allowScripts); */
  NS_IMETHOD InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts) = 0;

  /* void uninstallSkin (in ACString skinName, in boolean useProfile); */
  NS_IMETHOD UninstallSkin(const nsACString & skinName, PRBool useProfile) = 0;

  /* void installLocale (in string baseURL, in boolean useProfile); */
  NS_IMETHOD InstallLocale(const char *baseURL, PRBool useProfile) = 0;

  /* void uninstallLocale (in ACString localeName, in boolean useProfile); */
  NS_IMETHOD UninstallLocale(const nsACString & localeName, PRBool useProfile) = 0;

  /* void installPackage (in string baseURL, in boolean useProfile); */
  NS_IMETHOD InstallPackage(const char *baseURL, PRBool useProfile) = 0;

  /* void uninstallPackage (in ACString packageName, in boolean useProfile); */
  NS_IMETHOD UninstallPackage(const nsACString & packageName, PRBool useProfile) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIXULCHROMEREGISTRY \
  NS_IMETHOD ReloadChrome(void); \
  NS_IMETHOD GetSelectedLocale(const nsACString & package, nsACString & _retval); \
  NS_IMETHOD RefreshSkins(void); \
  NS_IMETHOD AllowScriptsForSkin(nsIURI *url, PRBool *_retval); \
  NS_IMETHOD SetAllowOverlaysForPackage(const PRUnichar *packageName, PRBool allowOverlays); \
  NS_IMETHOD InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts); \
  NS_IMETHOD UninstallSkin(const nsACString & skinName, PRBool useProfile); \
  NS_IMETHOD InstallLocale(const char *baseURL, PRBool useProfile); \
  NS_IMETHOD UninstallLocale(const nsACString & localeName, PRBool useProfile); \
  NS_IMETHOD InstallPackage(const char *baseURL, PRBool useProfile); \
  NS_IMETHOD UninstallPackage(const nsACString & packageName, PRBool useProfile); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIXULCHROMEREGISTRY(_to) \
  NS_IMETHOD ReloadChrome(void) { return _to ReloadChrome(); } \
  NS_IMETHOD GetSelectedLocale(const nsACString & package, nsACString & _retval) { return _to GetSelectedLocale(package, _retval); } \
  NS_IMETHOD RefreshSkins(void) { return _to RefreshSkins(); } \
  NS_IMETHOD AllowScriptsForSkin(nsIURI *url, PRBool *_retval) { return _to AllowScriptsForSkin(url, _retval); } \
  NS_IMETHOD SetAllowOverlaysForPackage(const PRUnichar *packageName, PRBool allowOverlays) { return _to SetAllowOverlaysForPackage(packageName, allowOverlays); } \
  NS_IMETHOD InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts) { return _to InstallSkin(baseURL, useProfile, allowScripts); } \
  NS_IMETHOD UninstallSkin(const nsACString & skinName, PRBool useProfile) { return _to UninstallSkin(skinName, useProfile); } \
  NS_IMETHOD InstallLocale(const char *baseURL, PRBool useProfile) { return _to InstallLocale(baseURL, useProfile); } \
  NS_IMETHOD UninstallLocale(const nsACString & localeName, PRBool useProfile) { return _to UninstallLocale(localeName, useProfile); } \
  NS_IMETHOD InstallPackage(const char *baseURL, PRBool useProfile) { return _to InstallPackage(baseURL, useProfile); } \
  NS_IMETHOD UninstallPackage(const nsACString & packageName, PRBool useProfile) { return _to UninstallPackage(packageName, useProfile); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIXULCHROMEREGISTRY(_to) \
  NS_IMETHOD ReloadChrome(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ReloadChrome(); } \
  NS_IMETHOD GetSelectedLocale(const nsACString & package, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSelectedLocale(package, _retval); } \
  NS_IMETHOD RefreshSkins(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RefreshSkins(); } \
  NS_IMETHOD AllowScriptsForSkin(nsIURI *url, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AllowScriptsForSkin(url, _retval); } \
  NS_IMETHOD SetAllowOverlaysForPackage(const PRUnichar *packageName, PRBool allowOverlays) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowOverlaysForPackage(packageName, allowOverlays); } \
  NS_IMETHOD InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts) { return !_to ? NS_ERROR_NULL_POINTER : _to->InstallSkin(baseURL, useProfile, allowScripts); } \
  NS_IMETHOD UninstallSkin(const nsACString & skinName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->UninstallSkin(skinName, useProfile); } \
  NS_IMETHOD InstallLocale(const char *baseURL, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->InstallLocale(baseURL, useProfile); } \
  NS_IMETHOD UninstallLocale(const nsACString & localeName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->UninstallLocale(localeName, useProfile); } \
  NS_IMETHOD InstallPackage(const char *baseURL, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->InstallPackage(baseURL, useProfile); } \
  NS_IMETHOD UninstallPackage(const nsACString & packageName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->UninstallPackage(packageName, useProfile); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsXULChromeRegistry : public nsIXULChromeRegistry
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIXULCHROMEREGISTRY

  nsXULChromeRegistry();

private:
  ~nsXULChromeRegistry();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsXULChromeRegistry, nsIXULChromeRegistry)

nsXULChromeRegistry::nsXULChromeRegistry()
{
  /* member initializers and constructor code */
}

nsXULChromeRegistry::~nsXULChromeRegistry()
{
  /* destructor code */
}

/* void reloadChrome (); */
NS_IMETHODIMP nsXULChromeRegistry::ReloadChrome()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getSelectedLocale (in ACString package); */
NS_IMETHODIMP nsXULChromeRegistry::GetSelectedLocale(const nsACString & package, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void refreshSkins (); */
NS_IMETHODIMP nsXULChromeRegistry::RefreshSkins()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean allowScriptsForSkin (in nsIURI url); */
NS_IMETHODIMP nsXULChromeRegistry::AllowScriptsForSkin(nsIURI *url, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setAllowOverlaysForPackage (in wstring packageName, in boolean allowOverlays); */
NS_IMETHODIMP nsXULChromeRegistry::SetAllowOverlaysForPackage(const PRUnichar *packageName, PRBool allowOverlays)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void installSkin (in string baseURL, in boolean useProfile, in boolean allowScripts); */
NS_IMETHODIMP nsXULChromeRegistry::InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void uninstallSkin (in ACString skinName, in boolean useProfile); */
NS_IMETHODIMP nsXULChromeRegistry::UninstallSkin(const nsACString & skinName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void installLocale (in string baseURL, in boolean useProfile); */
NS_IMETHODIMP nsXULChromeRegistry::InstallLocale(const char *baseURL, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void uninstallLocale (in ACString localeName, in boolean useProfile); */
NS_IMETHODIMP nsXULChromeRegistry::UninstallLocale(const nsACString & localeName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void installPackage (in string baseURL, in boolean useProfile); */
NS_IMETHODIMP nsXULChromeRegistry::InstallPackage(const char *baseURL, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void uninstallPackage (in ACString packageName, in boolean useProfile); */
NS_IMETHODIMP nsXULChromeRegistry::UninstallPackage(const nsACString & packageName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_CHROMEREGISTRY_CONTRACTID \
  "@mozilla.org/chrome/chrome-registry;1"
/**
 * Chrome registry will notify various caches that all chrome files need
 * flushing.
 */
#define NS_CHROME_FLUSH_TOPIC \
  "chrome-flush-caches"
/**
 * Chrome registry will notify various caches that skin files need flushing.
 * If "chrome-flush-caches" is notified, this topic will *not* be notified.
 */
#define NS_CHROME_FLUSH_SKINS_TOPIC \
  "chrome-flush-skin-caches"

#endif /* __gen_nsIChromeRegistry_h__ */
