/***************************************************************************
 *   Copyright (C) 2003 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef OPTIONS_H
#define OPTIONS_H

#include <map>
using namespace std;

#include <qstring.h>


//! Class that contains all the options for a document.
/*!
 * \author Antonio Fasolato <Antonio.Fasolato@poste.it>
 * \version 1.0
 *
 * Class that contains all the options for a document. These options regards the most disparate values: output formats, algorithm to use with potrace...<BR>
 * Mainly this class contains options relevant to potrace.
 */
class Options{
public:
	//! Default constructor
    Options();

	 //! Sets a pair (key,value) in this Options object.
	 /*! 
	  * \param key The name of the option. Later on it will be used to read its value
	  * \param value The value associated with the key
	  * 
	  * Sets a pair (key,value) in this Options object. If name is not in this object, it is added.
	  *
	  * \sa operator[]()
	  */
    void setValue(QString key, QString value);
	 //! Checks if the object contains no keys
	 /*!
	  * \returns \b true if the object is empty, \b false otherwise
	  */
    bool isEmpty();
	 //! Clears all the options in the object
    void clear();

	 //! Retrives an option value from the key associated whith it
	 /*!
	  * \param key the key of the option to retrive
	  * \returns The value associated with the key
	  * \sa setValue()
	  */
	 QString operator[](QString key);
	 //! Sets all the options to their default value.
	 void defaultOptions();
	 //! Prints the list of options
// 	 void debug();

private:
	map<QString,QString> options; /*!< The map containing the options */
};

#endif
