/***************************************************************************
 *   Copyright (C) 2005 by Tim Fechtner                                    *
 *   Tim.Fechtner@gmx-topmail.de                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PIXELVIEW_H
#define PIXELVIEW_H

#include <qscrollview.h>
#include <qlabel.h>
#include <qnamespace.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qguardedptr.h>
#include <kpixmapio.h>
#include <kimageeffect.h> 

#include "thresholddialog.h"

/**
@author Tim Fechtner
*/
class PixelView : protected QScrollView
{
Q_OBJECT
public:
    PixelView(QWidget *parent = 0, const char *name = 0, WFlags f = 0 );

    ~PixelView();
    void deleteImage();
    bool imagePresent() const;
    QImage displayedImage() const;
    void changeToImage(const QImage &image);
    
    bool thresholdingEnabled() const;
    double thresholdPercent() const;
    bool invert() const;
    
    void thresholdUI();
    void fitToPage();
    void fitToWidth();
    void fitToHeight();
    void zoomIn();
    void zoomOut();
    void zoom();
    
public slots:
    void setOptions(bool m_thresholdingEnabled,double m_thresholdPercent,bool m_invert);
    void setThresholdingEnabled(bool enabled);
    void setThresholdPercent(double value);
    void setInvert(bool value);
    
protected:
    QGuardedPtr<QLabel> label;
    QImage originalImage;
    QImage changedImage;
    QImage scaledImage;
    KPixmapIO pixmapIO;
    QGuardedPtr<thresholdDialog> theThresholdDialog;
    
    
    bool internImagePresent;
    
    unsigned int internZoom;
    bool internThresholdingEnabled;
    unsigned int internThreshold;
    double internThresholdPercent;
    bool internInvert;
    
    bool internGuardChanges;
    

    void internUpdatePixmap();

};

#endif
