/***************************************************************************
 *   Copyright (C) 2004 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "potracegui.h"
#include "mainwidget.h"

#include <qlabel.h>
#include <qclipboard.h>
#include <qmessagebox.h>

#include <kmainwindow.h>
#include <klocale.h>
#include <kstatusbar.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kpopupmenu.h>
#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kio/netaccess.h>
#include <kimageio.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kmessagebox.h>
#include <kaboutdata.h>
#include <kglobal.h>


potracegui::potracegui()
    : KMainWindow( 0, "potracegui" ), m_centralWidget(new MainWidget(this))
{
	// set the shell's ui resource file
	setXMLFile("potraceguiui.rc");
	KImageIO::registerFormats();
	 
	setCentralWidget(m_centralWidget);
	
	setAcceptDrops(true);
	 
	statusBar()->show();
	statusBar()->message(i18n("Welcome to %1 %2").arg(KGlobal::instance()->aboutData()->programName()).arg(KGlobal::instance()->aboutData()->version()));
	setAutoSaveSettings();
	setAcceptDrops(true);

	connect(m_centralWidget,SIGNAL(signalChangeStatusbar(QString)),this,SLOT(changeStatusbar(QString)));
	 
	createInterface();
}

potracegui::~potracegui()
{
}

void potracegui::createInterface()
{
	 /*handled by potracegui*/
	 KStdAction::openNew(this, SLOT(fileNew()),actionCollection());
	 KStdAction::quit(this, SLOT(quit()),actionCollection());
	 m_toolbarAction=KStdAction::showToolbar(this, SLOT(showToolbar()),actionCollection());
	 m_statusbarAction=KStdAction::showStatusbar(this, SLOT(showStatusbar()),actionCollection());
	 KStdAction::keyBindings(this, SLOT(configureKeys()),actionCollection());
	 KStdAction::configureToolbars(this, SLOT(configureTB()),actionCollection());
	 
	 /*handled by MainWidget*/
	 KStdAction::open(m_centralWidget, SLOT(fileOpen()),actionCollection());
	 //KStdAction::save(m_centralWidget, SLOT(fileSave()),actionCollection());
	 KStdAction::saveAs(m_centralWidget, SLOT(fileSaveAs()),actionCollection());
	 KStdAction::close(m_centralWidget, SLOT(fileClose()),actionCollection());
	 //KStdAction::undo(m_centralWidget, SLOT(undo()),actionCollection());  //for working one time
	 //KStdAction::redo(m_centralWidget, SLOT(redo()),actionCollection());  //for working one time
	 KStdAction::cut(m_centralWidget, SLOT(cut()),actionCollection());
	 KStdAction::copy(m_centralWidget, SLOT(copy()),actionCollection());
	 KStdAction::paste(m_centralWidget, SLOT(paste()),actionCollection());
	 KStdAction::fitToPage(m_centralWidget, SLOT(fitToPage()),actionCollection());
	 KStdAction::fitToWidth(m_centralWidget, SLOT(fitToWidth()),actionCollection());
	 KStdAction::fitToHeight(m_centralWidget, SLOT(fitToHeight()),actionCollection());
	 KStdAction::zoomIn(m_centralWidget, SLOT(zoomIn()),actionCollection());
	 KStdAction::zoomOut(m_centralWidget, SLOT(zoomOut()),actionCollection());
	 //KStdAction::zoom(m_centralWidget, SLOT(zoom()),actionCollection());
	 
	 /*custom actions*/
	 m_imageManipulation = new KAction (	i18n("&Colors"),
	 					0,
						m_centralWidget,
						SLOT(imageManipulation()),
						actionCollection(),
						"imageManipulation"
	 					);
	 
	 /*Create menu and toolbar*/
	 createGUI();
}


//MENU ACTIONS
void potracegui::fileNew()
{
	(new potracegui)->show();
}

void potracegui::quit()
{
	close();
}

void potracegui::showToolbar()
{
	if(m_toolbarAction->isChecked())
		toolBar()->show();
	else
		toolBar()->hide();
}

void potracegui::showStatusbar()
{
	if(m_statusbarAction->isChecked())
		statusBar()->show();
	else
		statusBar()->hide();
}

void potracegui::configureKeys()
{
	KKeyDialog::configure(actionCollection(),"potraceguiui.rc");
}

void potracegui::configureTB()
{
	KEditToolbar dlg(actionCollection());
	connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(NewTBConfig()));
	dlg.exec();
}

void potracegui::NewTBConfig()
{
	createGUI();
	saveMainWindowSettings(KGlobal::config());
}

void potracegui::changeStatusbar(QString message)
{
	statusBar()->message(message);
}

bool potracegui::queryClose() {
	if(m_centralWidget->m_changed) {
		int res= KMessageBox::warningYesNoCancel(this, i18n("Save changes?"));
		if(res==KMessageBox::Yes) {
			m_centralWidget->fileSaveAs();
			return true;
		}
		else if(res==KMessageBox::Cancel) {
			return false;
		}
		if(res==KMessageBox::No) {
			return true;
		}
	}
	return true;
}

#include "potracegui.moc"
