/***************************************************************************
 *   Copyright (C) 2005 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "thresholddialog.h"
#include "thresholddialog.moc"

thresholdDialog::thresholdDialog(QWidget *parent)
 : KDialogBase(	parent,
		"blackandwhitedialog",
		TRUE,
		i18n("black and white conversion"),
		KDialogBase::Ok|KDialogBase::Cancel|KDialogBase::Apply
	      )
{	
	QWidget *page = new QWidget( this );
	setMainWidget(page);
	QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
	
	checkBox1 = new QCheckBox( i18n("&convert to black and white"), page, "checkBox1" );
	checkBox1->setEnabled( TRUE );
	checkBox1->setChecked( FALSE );
	topLayout->addWidget( checkBox1 );
	
	theslider = new KDoubleNumInput(page, "internalNameSlider");
	theslider->setLabel(i18n("&Threshold"),AlignLeft|AlignVCenter);
	theslider->setPrecision(1);
	theslider->setRange(0,100,0.5,TRUE);
	theslider->setValue(50);
	theslider->setEnabled( FALSE );
	topLayout->addWidget( theslider );
	
	checkBox2 = new QCheckBox( i18n("&invert"), page, "checkBox2" );
	checkBox2->setEnabled( FALSE );
	checkBox1->setChecked( FALSE );
	topLayout->addWidget( checkBox2 );
	
	connect( checkBox1, SIGNAL( toggled(bool) ), theslider, SLOT( setEnabled(bool) ) );  //gui
	connect( checkBox1, SIGNAL( toggled(bool) ), checkBox2, SLOT( setEnabled(bool) ) );  //gui

	connect( this, SIGNAL( apply() ), this, SLOT( m_valuesChanged() ) );  
	connect( this, SIGNAL( okClicked() ), this, SLOT( m_valuesChanged() ) );
}


thresholdDialog::~thresholdDialog()
{
}


/*!
    \fn thresholdDialog::show(bool doThreshold, unsigned int theThreshold, bool doInvert)
 */
void thresholdDialog::show(bool doThreshold, double theThreshold, bool doInvert)
{
    checkBox1->setChecked(doThreshold);
    original_doThreshold = doThreshold;
    theslider->setValue(theThreshold);
    original_theThreshold = theThreshold;
    checkBox2->setChecked(doInvert);
    original_doInvert = doInvert;
    KDialogBase::show();
}





void thresholdDialog::m_valuesChanged()
{
    emit valuesChanged(checkBox1->isChecked(),theslider->value(),checkBox2->isChecked());
}
