/***************************************************************************
 *   Copyright (C) 2005 by Tim Fechtner                                    *
 *   Tim.Fechtner@gmx-topmail.de                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef THRESHOLDDIALOG_H
#define THRESHOLDDIALOG_H

#include <kdialogbase.h>
#include <knuminput.h>
#include <klocale.h>

#include <qlayout.h>
#include <qobject.h>
#include <qcheckbox.h>
#include <qnamespace.h>


/**
@author Tim Fechtner
*/
class thresholdDialog : public KDialogBase
{
Q_OBJECT
public:
    thresholdDialog(QWidget *parent);
    ~thresholdDialog();
    virtual void show(bool doThreshold, double theThreshold, bool doInvert);

signals:
    void valuesChanged(bool, double, bool);

    
protected:
    QCheckBox *checkBox1;
    KDoubleNumInput *theslider;
    QCheckBox *checkBox2;
    bool original_doThreshold;
    double original_theThreshold;
    bool original_doInvert;
        
protected slots:
    void m_valuesChanged();

};

#endif
