#!/bin/bash
############################################################################
# Copyright:
#      (C) 2008  Alexander Shaduri <ashaduri 'at' gmail.com>
# License: See LICENSE_zlib.txt file
############################################################################

# Run gsmartcontrol with root, asking for root password first.

EXEC_BIN="/usr/bin/gsmartcontrol";
prog_name="gsmartcontrol"

DESKTOP="$1";

# This works for --help too
if [ "$DESKTOP" = "" ]; then
	DESKTOP="other";  # default

elif [ "$DESKTOP" != "kde" ] && [ "$DESKTOP" != "gnome" ] && [ "$DESKTOP" != "other" ]; then
	echo "Usage: $0 <desktop_name> [<${prog_name}_options>]";
	echo "Desktop name may be kde, gnome, other.";
	exit 1;
fi
shift;  # remove $1


# They're basically the same, only the order is different.
# sux requires xterm to ask for the password.
# xdg-su is basically like this script, except worse :)
gnome_sus="gnomesu gksu kdesu xdg-su sux";
kde_sus="kdesu gnomesu gksu xdg-su sux";
other_sus="$gnome_sus";


candidates="";
found_su=""

if [ "$DESKTOP" = "gnome" ]; then
	candidates="$gnome_sus";
elif [ "$DESKTOP" = "kde" ]; then
	candidates="$kde_sus";
elif [ "$DESKTOP" = "other" ]; then
	candidates="$other_sus";
fi

for subin in $candidates; do
	which $subin &>/dev/null
	if [ $? -eq 0 ]; then
		found_su="$subin";
		break;
	fi
done

if [ "$found_su" = "" ]; then
	xmessage "Error launching ${prog_name}: No suitable su mechanism found.
Try installing gnomesu, kdesu or sux first.";
	exit 1;
fi

# echo $found_su;

# gnomesu -c 'gsmartcontrol --no-scan'
# kdesu -c 'gsmartcontrol --no-scan'
# xterm -e sux -c 'gsmartcontrol --no-scan'  # sux asks for password in a terminal

full_cmd=""
if [ "$found_su" = "sux" ]; then
	full_cmd="xterm -e sux -c '$EXEC_BIN $@'"

elif [ "$found_su" = "gksu" ]; then
	full_cmd="$found_su '$EXEC_BIN $@'"

else  # gnomesu, kdesu, xdg-su
	full_cmd="$found_su -c '$EXEC_BIN $@'"
fi


eval $full_cmd




