Name:		gsmartcontrol
Version:	0.8.1
Release:	1as
License:	GPLv2, GPLv3
Vendor:		Alexander Shaduri <ashaduri 'at' gmail.com>
Url:		http://gsmartcontrol.berlios.de
Packager:	Alexander Shaduri <ashaduri 'at' gmail.com>
Group:		Hardware/Other
Source:		gsmartcontrol-%{version}.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-build
Summary:	GSmartControl - Hard Disk Health Inspection Tool

# Support build service rpmlint. Disabled - the build service
# stopped recognizing the flag for some architectures.
# %if 0%{?opensuse_bs} && 0%{?suse_version} >= 1010
# Support: rpmlint-bs
# %endif


# Dependencies for various distributions. The actual deps are:
# smartmontools, pcre, (gtkmm2 >= 2.12 || (gtkmm2 >= 2.6.0 && libglademm >= 2.4.0))
# (with the respective -devel packages of the libraries for build requirements).
# For non-specified distributions we don't specify any dependencies to avoid errors.


# SUSE / OpenSUSE. SLES also defines the correct suse_version.
%if 0%{?suse_version}

%if 0%{?%suse_version} >= 1030
Requires: smartmontools, pcre, gtkmm2 >= 2.12.0
BuildRequires: gcc-c++, libstdc++-devel, pcre-devel, gtkmm2-devel >= 2.12.0
%else
Requires: smartmontools, pcre, gtkmm2 >= 2.6.0, libglademm >= 2.4.0
BuildRequires: gcc-c++, libstdc++-devel, pcre-devel, gtkmm2-devel >= 2.6.0, libglademm-devel >= 2.4.0
%endif

%endif


# Fedora, CentOS, RHEL
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}

# I'm not sure about centos and rhel versions
%if 0%{?fedora_version} >= 8 || 0%{?rhel_version} >= 600 || 0%{?centos_version} >= 600
Requires: smartmontools, pcre, gtkmm24 >= 2.12.0
BuildRequires: gcc-c++, pcre-devel, gtkmm24-devel >= 2.12.0
%else
Requires: smartmontools, pcre, gtkmm24 >= 2.6.0, libglademm24 >= 2.4.0
BuildRequires: gcc-c++, pcre-devel, gtkmm24-devel >= 2.6.0, libglademm24-devel >= 2.4.0
%endif

%endif


# Mandriva
%if 0%{?mandriva_version}

%if 0%{?mandriva_version} >= 2008
Requires: smartmontools, libpcre0, libgtkmm2.4_1 >= 2.12.0
BuildRequires: gcc-c++, gcc-cpp, libpcre-devel, libgtkmm2.4-devel >= 2.12.0
%else
Requires: smartmontools, libpcre0, libgtkmm2.4_1 >= 2.6.0, libglademm2.4_1 >= 2.4.0
BuildRequires: gcc-c++, gcc-cpp, libpcre-devel, libgtkmm2.4-devel >= 2.6.0, libglademm2.4_1-devel >= 2.4.0
%endif

%endif


%description
GSmartControl is a graphical user interface for smartctl, which is a tool for
querying and controlling SMART (Self-Monitoring, Analysis, and Reporting
Technology) data in hard disk drives. It allows you to inspect the drive's
SMART data to determine its health, as well as run various tests on it.

%prep


%setup -q
%configure
# Don't use configure parameters - let rpm set them.
# --prefix=/usr --enable-default-gcc-options --enable-gcc-optimize


%build
# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
	numprocs=1
fi

make -j$numprocs
# make


%install
# %makeinstall
make DESTDIR=%buildroot install


%clean
rm -rf %buildroot


%files
%defattr(-,root,root)

%attr(0755,root,root) %{_bindir}/*
# %attr(0644,root,root) %config(noreplace) %{_sysconfdir}/*

%doc %{_datadir}/doc/gsmartcontrol

%{_datadir}/gsmartcontrol
# %{_datadir}/gsmartcontrol/*
%{_datadir}/applications/*.desktop
%{_datadir}/icons/*
%{_datadir}/pixmaps/*


%changelog
* Mon Oct 06 2008 Alexander Shaduri <ashaduri 'at' gmail.com>
- Updated .spec file to support OpenSUSE < 10.3, Fedora and friends,
	Mandriva (for OpenSUSE Build Service).

* Mon Sep 15 2008 Alexander Shaduri <ashaduri 'at' gmail.com>
- Initial .spec file.

