/***************************************************************************
 *   Copyright (C) 2006 by                                                 *
 *   Flavio Castelli, micron@madlab.it                                     *
 *   Ken Werner, ken.werner@web.de                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef IBOOKG4THERMALSRC_H
#define IBOOKG4THERMALSRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <qfile.h>
#include <list>

/**
 * @author Flavio Castelli
 * @author Ken Werner
 * IbookG4ThermalSrc reads temperature values from /sys/devices/temperatures/sensor[1,2]_temperature
 * It may work on other Apple machines as well (please let me know)
 */
class IbookG4ThermalSrc : public LabelSource {
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source from the given File
	 */
	IbookG4ThermalSrc(QWidget* inParent, const QFile& inSourceFile, const QString& inName);
	virtual ~IbookG4ThermalSrc();
	
	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(QWidget* inParent);

	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual QString fetchValue();

private:
	/**
	 * The file from which the value is read
	 */
	QFile mSourceFile;

	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;
};
#endif // IBOOKG4THERMALSRC_H
