/* NVTV simple API wrapper for client backend
 *
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: nvtv_simple.h,v 1.3 2004/03/06 10:41:30 snaggen Exp $
 *
 * Contents:
 *
 * Initial coding by Matthias Hopf <mat@mshopf.de>
 * Extracted by Mattias Eriksson <snaggen@acc.umu.se>
 *
 */

/*********************************************************************
 * TV-mode API, to make it possible to use nvtvd to view movies      *
 *********************************************************************/

typedef enum {
	NVTV_SIMPLE_TVSYSTEM_PAL    = 0,
	NVTV_SIMPLE_TVSYSTEM_NTSC   = 1,
} nvtv_simple_tvsystem;

/* FIXME Note: There is already an enumeration of TV systems in 
 * tvchip.h, I am not sure if this should really be duplicated again.
 * - Dirk
 */

#define NVTV_SIMPLE_TV_OFF 0
#define NVTV_SIMPLE_TV_ON 1

/* connect to nvtvd server and save current TV and X settings */
int nvtv_simple_init ();

/* Enable the use of xrandr to autofit the screen to match the TV-resolution */
int nvtv_enable_autoresize (int enable);

/* Function to see if nvtv is available and enabled */
int nvtv_simple_is_available();

/* Turn tvmode on/off (1/0)*/
int nvtv_simple_enable(int use_tvmode);

/* Set which tv system to use: XINE_TVSYSTEM_PAL or XINE_TVSYSTEM_NTSC */
void nvtv_simple_set_tvsystem(nvtv_simple_tvsystem system);

/* try to change TV state if enabled
 *   type select NVTV_SIMPLE_TV_OFF or NVTV_SIMPLE_TV_ON
 *   width frame width the mode should match best or 0 if unknown
 *   height frame height the mode should match best or 0 if unknown
 * returns: finally selected type
 */
int nvtv_simple_switch (int type, int width, int height);

/*
 * Get the current state, is TV on or off?
 * returns NVTV_SIMPLE_TV_OFF/NVTV_SIMPLE_TV_ON
 */
int nvtv_simple_get_state();

/* adapt (maximum) output size to visible area if necessary and return pixel
 * aspect and real frame rate if available
 */
void nvtv_simple_size (int *width, int *height,
		       double *pixelratio, double *fps);

/* restore old TV and X settings and close nvtvd connection */
void nvtv_simple_exit ();
       
