/***************************************************************************
                           chttp.h  -  description
                             -------------------
    begin                : Mon Jul 29 2002
    copyright            : (C) 2002-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHTTP_H
#define CHTTP_H

/**
  *@author Mathias Küster
  *
  * HTTP protocol class for downloading filelists, valknut uses
  * QT's QHttp instead.
  */

#include <dclib/dcos.h>
#include <dclib/core/cbytearray.h>
#include <dclib/core/cconnection.h>
#include <dclib/core/ccallback.h>

class CDCMessage;

typedef enum eUrlMethod {
	eumGET,
	eumPOST
} eUrlMethod;

class CHttp : public CConnection {
public:
	/** */
	CHttp();
	/** */
	virtual ~CHttp();

	/** */
	int GetUrl( CString url, CString postdata = CString() );
	/** */
	bool GetData( CByteArray * ba );

	/** callback function */
	virtual int DC_CallBack( CDCMessage * ) { return -1; };
	/** */
	virtual void ConnectionState( eConnectionState );
	/** */
	virtual void DataAvailable( const char *, int );
	/** */
	virtual void DataSend();
	/** */
	virtual void DataTimeout();
	/** */
	virtual void Notify();

	/** */
	void SetCallBackFunction( _CCallback1<CDCMessage*> * callback );
	/** */
	CString GetUrl() { return m_sUrl; }
	/** */
	CString GetLocation() { return m_sLocation; }
	/** */
	int GetHttpError() { return m_nErrorCode; }
	/** */
	static CString Encode( CString s );
	/** */
	static CString Decode( CString s );
	/** Parses "user:pass@host:port" user, pass, port optional, port defaults to 8080 */
	static bool ParseProxy( char * proxy, CString & user, CString & pass, CString & host, unsigned int & port );

private:
	/** Called by CManager to run this instead of starting it's own thread */
	int Callback();
	/** */
	int CallBack_SendObject( CDCMessage * DCMessage );

	/** */
	void AppendData( const char * buffer, int len );
	/** */
	CList<CDCMessage> * m_pMessageList;
	/** */
	eConnectionState m_eMode;
	/** */
	CString m_sUrl;
	/** */
	CString m_sHost;
	/** */
	CString m_sPort;
	/** */
	CString m_sProxy;
	/** */
	CString m_sProxyPort;
	/** */
	CString m_sProxyUser;
	/** */
	CString m_sProxyPass;
	/** */
	eUrlMethod m_eUrlMethod;
	/** */
	int m_nErrorCode;
	/** */
	bool m_bData;
	/** */
	CString m_sLocation;
	/** */
	CString m_sHeader;
	/** */
	CString m_sPostData;
	/** */
	long m_nContentLength;
	/** */
	CByteArray m_baData;
	/** */
	_CCallback1<CDCMessage*> * m_pHttpCallback;
	/** */
	_CCallback0 * m_pCallback;
};

inline void CHttp::SetCallBackFunction( _CCallback1<CDCMessage*> * callback )
{ delete m_pHttpCallback; m_pHttpCallback = callback; }

#endif
