/***************************************************************************
                           casyncdns.h  -  description
                             -------------------
    begin                : Mon Jun 10 2002
    copyright            : (C) 2002-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CASYNCDNS_H
#define CASYNCDNS_H

/**
  *@author Mathias Küster
  *
  * This is a thread that is permanently running to do DNS
  * lookups so that they do not block the other dclib thread (CManager).
  *
  * The CNetAddr lookup function is supposed to be re-entrant since it
  * uses getaddrinfo(), so more than one lookup could be done
  * simultaneously, but this class does not do that.
  */

#include <time.h>

#ifndef WIN32
#include <netinet/in.h>
#endif

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cthread.h>
#include <dclib/core/csingleton.h>
#include <dclib/core/cstringlist.h>

/** */
typedef enum eAsyncDns {
	eadSUCCESS,
	eadERROR,
	eadAGAIN
} eAsyncDns;

class CAsyncDnsEntry {
public:
	/** */
	CAsyncDnsEntry() {};
	/** */
	~CAsyncDnsEntry() {};

	/** */
	CString m_sHost;
	/** */
	bool m_bError;
	/** socket error message */
	CString m_sErrMsg;
	/** query timeout */
	time_t m_tTimeout;
	/** */
	struct sockaddr_in m_sin;
};

class CAsyncDns : public CSingleton<CAsyncDns>, public CThread {

public:
	/** */
	CAsyncDns();
	/** */
	virtual ~CAsyncDns();

	/** */
	eAsyncDns GetHostI4( CString stringHost, struct sockaddr_in * sin, CString * errmsg = 0 );

	/** */
	virtual void Thread();

private:
	/** */
	void UpdateEntry( CString stringHost );
	/** */
	CStringList<CAsyncDnsEntry> * m_pHostCache;
	/** */
	CStringList<CAsyncDnsEntry> * m_pHostList;
};

#endif
