/***************************************************************************
                           cdir.h  -  description
                             -------------------
    begin                : Tue May 14 2002
    copyright            : (C) 2002-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDIR_H
#define CDIR_H

/**
  *@author Mathias Küster
  *
  * Mainly for reading directories, it also provides
  * SimplePath() which just removes "." ".." and multiple
  * directory separators from a path.
  */

#include <time.h>

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/clist.h>

class CFileInfo {
public:
	/** */
	CFileInfo() {};
	/** */
	~CFileInfo() {};

	/** */
	CString name;
	/** */
	ulonglong size;
	/** */
	bool m_bSymlink;
	/** */
	time_t st_a_time;
	/** */
	time_t st_m_time;
	/** */
	time_t st_c_time;
};

class CDir {

public:
	/** */
	CDir();
	/** */
	CDir( CString path );
	/** */
	~CDir();

	/**
	 * Using Dirs|Files is NOT supported, you would get nothing.
	 * You would not be able to distinguish between files and
	 * directories in the output anyway.
	 */
	typedef enum FilterSpec {
		Dirs  = 0x0001,
		Files = 0x0002
	} FilterSpec;

	/** */
	static CString HomeDirPath();
	/** */
	bool cd( CString path );
	/** */
	static CString Extension( CString file );
	/** */
	CString Path();
	/** */
	CString DirName();
	/** */
	static CString ConvertSeparators( CString path );
	/** */
	static CString SimplePath( CString path );
	/** */
	ulonglong getFileSize( CString filename, bool rel = true );
	/** returns true if you have read access to the file */
	bool canReadFile( const CString & file, bool rel = true );
	/**
	 * Resolves all .. . and symbolic links, and converts to an absolute
	 * path relative to this directory's path. If the supplied path is
	 * already absolute it is still simplified. All components of the path
	 * must exist and be accessible. Repeated path separators are simplified
	 */
	CString Canonicalize( const CString & path );

	/** */
	static void SplitPathFile( CString string, CString & path, CString & file );
	/** */
	bool CreatePath( CString path );
	/** */
	bool ReadEntrys( FilterSpec filterspec, CList<CFileInfo> * list, const bool checkPerms = true );
	/** */
	bool IsDir( CString s, bool rel = true );
	/** */
	bool IsFile( CString s, bool rel = true );

	/** */
	void SetPath( CString path );
	/** */
	static bool FreeDiscSpace( CString path, ulonglong * res );
	/**
	 * Remove a directory specified by it's absolute path
	 * which must be empty. Returns true it it succeeds.
	 */
	static bool RmDir( const CString & abspath );

private:
#ifdef WIN32
	/** */
	bool GetStat( CString & s, struct _stati64 * buf, bool rel = true );
	/** */
	bool GetLStat( CString & s, struct _stati64 * buf, bool rel = true );
#else
	/** */
	bool GetStat( CString & s, struct stat * buf, bool rel = true );
	/** */
	bool GetLStat( CString & s, struct stat * buf, bool rel = true );
#endif

	/** */
	CString sPath;
	/** */
	CString sDrive;
};

#endif
