#ifndef DCLIB_SSL_USE_H
#define DCLIB_SSL_USE_H

/*
 * This used to be needed because the dclib compatibility depended
 * on if it was compiled with SSL or not. That is no longer the case.
 * However, it appears to be impossible to forward declare OpenSSL
 * items because they are declared using typedef, so this header
 * is still needed since dclib does not install it's config.h.
 */

#define DCLIB_HAS_SSL 1

/*
 * Similarly, if I do things properly, it won't matter which SSL
 * library dclib was compiled to use. Currently only OpenSSL is supported.
 * However adding support for GnuTLS or NSS will require changing the
 * CSSL API.
 */

#define DCLIB_USES_OPENSSL 1

#endif
