/***************************************************************************
                          cbytearray.h  -  description
                             -------------------
    begin                : Fri Mar 22 2002
    copyright            : (C) 2002-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CBYTEARRAY_H_
#define _CBYTEARRAY_H_

/**
  *@author Mathias Küster
  *
  * It is a byte array, with almost no functions, SetSize() always deletes
  * any previous content.
  *
  * Appending (part of) a byte array to itself never used to work, memcpy()
  * does not handle memory areas that overlap, dclib does not
  * require this to work, there is a printf() if it happens, but it should
  * also work.
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>

class CByteArray {
public:
	/** */
	CByteArray( unsigned long nSize = 0 );
	/** */
	~CByteArray();

	/** */
	void SetSize( unsigned long nNewSize );
	/**
	 * Does realloc() i.e. not like SetSize(), this
	 * can shrink or grow the byte array preserving (some of)
	 * the contents.
	 */
	bool Realloc( unsigned long newsize );
	/** */
	void Append( const unsigned char * pchSrc, unsigned long nSize );
	/** */
	void Append( const char * pchSrc, unsigned long nSize ) { Append( (const unsigned char*)pchSrc, nSize ); };
	/** */
	unsigned char * Data();
	/** */
	unsigned long Size() const;
	
	/** */
	bool LoadFromFile( CString file );
	/** */
	bool SaveToFile( CString file );

private:
	/** */
	void Clear();

	/** */
	unsigned char * m_pchBuffer;
	/** */
	unsigned long m_nSize;
	/** */
	unsigned long m_nBufferSize;
};

/** */
inline unsigned char * CByteArray::Data()
{ return m_pchBuffer; }
/** */
inline unsigned long CByteArray::Size() const
{ return m_nSize; }

#endif

