/***************************************************************************
                           clogfile.h  -  description
                             -------------------
    begin                : Sat Dec 14 2002
    copyright            : (C) 2002-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLOGFILE_H
#define CLOGFILE_H

/**
  *@author Mathias Küster
  *
  * Writes text to a file, because it's a log file that
  * requires opening, writing, and closing to ensure it is saved.
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cmutex.h>

typedef enum eLogType {
	eltINFO,
	eltWARNING,
	eltERROR
}eLogType;

class CLogFile {

public:
	/** */
	static bool Write( CString file, eLogType type, CString message );

protected:
	/** */
	CLogFile();
	/** */
	~CLogFile();

private:
	/** */
	static CMutex m_LogFileMutex;
};

#endif
