/***************************************************************************
                           cplugin.h  -  description
                             -------------------
    begin                : Fri Sep 27 2002
    copyright            : (C) 2002-2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CPLUGIN_H
#define CPLUGIN_H

/**
  *@author Mathias Küster
  *
  * The interface for a dclib plugin which is almost completely
  * unused.
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>

typedef enum ePluginType {
	eptNONE,
	eptLIB,
	eptGUI
} ePluginType;

class CPlugin {
public:
	/** */
	CPlugin() {};
	/** */
	virtual ~CPlugin() {};

	/** init function */
	virtual bool Init() = 0;

protected:
	/** It is called by CManager so takes no parameters */
	virtual int PluginCallback() { return 0; };
};

typedef struct ePluginStruct {
	/** */
	CPlugin * m_pPlugin;
	/** */
	void (*init) (void);
	/** */
	void (*deinit) (void);
	/** */
	ePluginType m_eType;
	/** Short description */
	CString m_sDesc;
	/** Version info */
	CString m_sVersion;

} ePluginStruct;

#endif
