/***************************************************************************
                          csearchsocket.cpp  -  description
                             -------------------
    begin                : Thu May 27 2004
    copyright            : (C) 2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "csearchsocket.h"

#include <stdio.h>

#include "dclib.h"
#include "core/cstring.h"
#include "cmessagehandler.h"

#include "dcobject.h"

/** */
CSearchSocket::CSearchSocket()
{
	m_pCallback = 0;
}

/** */
CSearchSocket::~CSearchSocket()
{
	SetCallBackFunction(0);
}

/** */
void CSearchSocket::DataAvailable( const char * c, int len )
{
	int p = 0, err;
	eDCMessage type;
	CDCMessage * Object = 0;
	CMessageHandler MessageHandler;
	
	/* FIXME should use Set(c,len) ? */
	CString s = c;
	
	/* add '|' for parser, only old dclib did not terminate search results? */
	s += '|';

	// add traffic control
	CSocket::m_Traffic.AddTraffic(ettCONTROLRX,len);

	while( (type=MessageHandler.Parse(&s,p,&Object)) != DC_MESSAGE_PARSE_ERROR )
	{
		switch (type)
		{
			case DC_MESSAGE_SEARCHRESULT:
			{
				break;
			}

			default:
			{
				// remove message
				delete Object;
				Object = 0;
				break;
			}
		}

		if (Object)
		{
			err = -1;

			if ( m_pCallback != 0 )
			{
				err = m_pCallback->notify( Object );
			}

			if ( err == -1 )
			{
				printf("CSearchSocket::HandleMessage: CallBack failed (state)...\n");
				delete Object;
			}
		}
	}
}
