/***************************************************************************
                          csearchsocket.h  -  description
                             -------------------
    begin                : Thu May 27 2004
    copyright            : (C) 2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSEARCHSOCKET_H
#define CSEARCHSOCKET_H

/**
  *@author Mathias Küster
  *
  * This class receives UDP packets and parses them into search results.
  * Because originally dclib did not terminate it's search results with a |,
  * the parser adds one. I think only 1 result is allowed per packet,
  * but like with most of the NMDC protocol it's probably undefined.
  *
  * FIXME why is this a CConnection when it's only for receiving UDP
  * packets which are connectionless...
  */

#include <dclib/dcos.h>
#include <dclib/core/cconnection.h>
#include <dclib/core/ccallback.h>
#include <dclib/core/cmutex.h>

class CDCMessage;

class CSearchSocket : public CConnection {
public:
	/** */
	CSearchSocket();
	/** */
	virtual ~CSearchSocket();

	/** */
	void SetCallBackFunction( _CCallback1<CDCMessage*> * callback );

	/** */
	virtual void DataAvailable( const char * buffer, int len );

private:
	/** callback function */
	_CCallback1<CDCMessage*> * m_pCallback;
	/** */
	CMutex m_SearchSocketMutex;
};

/** */
inline void CSearchSocket::SetCallBackFunction( _CCallback1<CDCMessage*> * callback )
{ m_SearchSocketMutex.Lock(); delete m_pCallback; m_pCallback = callback; m_SearchSocketMutex.UnLock(); }

#endif
