/***************************************************************************
                          cutils.h  -  description
                             -------------------
    begin                : Fri May 16 2003
    copyright            : (C) 2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CUTILS_H
#define CUTILS_H

/**
  *@author Mathias Küster
  *
  * Formatting of sizes, times and rates. Also parsing of dcfile:// links.
  * 
  * This whole thing should probably be in valknut, QString is more
  * efficient and the units could be translated. I don't think dclib
  * ever has to process a dcfile:// link and valknut and other clients
  * use magnet links anyway.
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/types.h>

class CUtils {
public:
	/** */
	static CString GetSizeString( const ulonglong size, eUnit unit );
	/* This will Convert Total Secs to how much time is
	 * remaining X Days + X Hrs + X Mins + X Secs */
	static CString GetTimeString( const ulonglong sec );
	/** */
	static CString GetTransferString( const ulonglong rate );
	/** */
	static bool ConvertDCLink( CString link, CString & hubhost, CString & hubname, CString & nick, ulonglong & size, CString & file, CString & tth );
	/** Extract major, minor and micro version numbers from a DC tag, returns true if at least major is found */
	static bool ParseVersionTag( const CString tag, int & major, int & minor, int & micro );

protected:
	/** */
	CUtils();
	/** */
	~CUtils();
};

#endif
