/*
 * This files fixes that the hashing code from DC++
 * can be used almost verbatim.
 */

#ifndef _INCLUDED_COMPAT_H_
#define _INCLUDED_COMPAT_H_

#ifdef _WIN32
#include <io.h>
#else // _WIN32

  // like O_LARGEFILE for open, this enables large files for stat
# define _FILE_OFFSET_BITS 64
# define _LARGEFILE64_SOURCE 1
# include <unistd.h>

#endif // _WIN32

#ifndef uint64_t
#include <stdint.h>
#endif

// standard includes
#include <string.h>
#include <vector>
#include <utility>
#include <algorithm>
using std::pair;
using std::make_pair;
using std::vector;

// algorithm include added for min and max functions
// also this typedef added for 0.707 from DCPlusPlus.h
typedef std::vector<uint8_t> ByteVector;

// defines used by the DC++ code
#ifndef _ULL
#define _ULL(x) x##ull
#endif
#define dcassert(x) 


#endif //_INCLUDED_COMPAT_H_
