/***************************************************************************
              tth-test.cpp  -  Test a TTH calculated is correct
                             -------------------
    begin                : Thu Sep 11 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dclib/core/cstring.h>
#include <dclib/core/cbytearray.h>
#include <dclib/core/cfile.h>
#include <dclib/cfilehasher.h>

#include <stdio.h>

int main( int /* argc */, char* [] /* argv */ )
{
	/* create test data */
	CByteArray buffer(50*1024*1024);
	
	for ( unsigned long i = 0; i < buffer.Size(); ++i )
	{
		buffer.Data()[i] = (unsigned char) (i%26 + 'a');
	}
	
	if ( buffer.SaveToFile("testdata.bin") == false )
	{
		printf("tth-test: cannot create testdata.bin file\n");
		return 1;
	}
	
	CFileHasher hasher("testdata.bin");
	hasher.ComputeHash();
	int ret = 100;
	if ( hasher.GetStatus() != efhsFinished )
	{
		printf("tth-test: error during hashing\n");
		ret = 2;
	}
	
	if ( hasher.GetHashRoot() == "B4OKDH3FH3JZJJBNN4OLNTCHW7TK7G2O6IG2JHQ" )
	{
		CByteArray * leaves = hasher.GetLeafData();
		if ( leaves && leaves->Size() > 0 )
		{
			if ( CFileHasher::ValidateHashLeaves( hasher.GetHashRoot(), leaves, buffer.Size() ) )
			{
				/* change leaf data */
				unsigned char c = leaves->Data()[0];
				if ( c == 0 )
				{
					c = 1;
				}
				else
				{
					c--;
				}
				
				leaves->Data()[0] = c;
				
				if ( CFileHasher::ValidateHashLeaves( hasher.GetHashRoot(), leaves, buffer.Size() ) == false )
				{
					ret = 0;
				}
				else
				{
					printf("tth-test: modified leaves passed validation!\n");
					ret = 6;
				}
			}
			else
			{
				printf("tth-test: leaves failed validation!\n");
				ret = 5;
			}
		}
		else
		{
			printf("tth-test: no leaves generated!\n");
			ret = 4;
		}
		
		if ( leaves )
		{
			delete leaves;
			leaves = 0;
		}
	}
	else
	{
		printf("tth-test: incorrect tth calculated!\n");
		ret = 3;
	}
	
	CFile::UnLink("testdata.bin");
	
	return ret;
}
