/*

    This file is a part of JVOIPLIB, a library designed to facilitate
    the use of Voice over IP (VoIP).

    Copyright (C) 2000-2005  Jori Liesenborgs (jori@lumumba.uhasselt.be)

    This library (JVOIPLIB) is based upon work done for my thesis at
    the School for Knowledge Technology (Belgium/The Netherlands)

    The full GNU Library General Public License can be found in the
    file LICENSE.LGPL which is included in the source code archive.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA

*/

#ifndef JVOIPERRORS_H

#define JVOIPERRORS_H

#include "jvoipconfig.h"
#include <iostream>
#include <string>

std::string JVOIPGetErrorString(int errcode);

#define ERR_JVOIPLIB_GENERAL_ERRORBASE						0
#define ERR_JVOIPLIB_GENERAL_OUTOFMEM						(ERR_JVOIPLIB_GENERAL_ERRORBASE-1)
#define ERR_JVOIPLIB_GENERAL_CANTINITMUTEX					(ERR_JVOIPLIB_GENERAL_ERRORBASE-2)
#define ERR_JVOIPLIB_GENERAL_CANTINITSIGWAIT					(ERR_JVOIPLIB_GENERAL_ERRORBASE-3)
#define ERR_JVOIPLIB_GENERAL_COMPONENTALREADYINIT				(ERR_JVOIPLIB_GENERAL_ERRORBASE-4)
#define ERR_JVOIPLIB_GENERAL_COMPONENTNOTINIT					(ERR_JVOIPLIB_GENERAL_ERRORBASE-5)
#define ERR_JVOIPLIB_GENERAL_ILLEGALSTATEPARAMETER				(ERR_JVOIPLIB_GENERAL_ERRORBASE-6)
#define ERR_JVOIPLIB_GENERAL_VOICEBLOCKINFODOESNTMATCHSETTINGS			(ERR_JVOIPLIB_GENERAL_ERRORBASE-7)

#define ERR_JVOIPLIB_VOIPTHREAD_ERRORBASE					-1024
#define ERR_JVOIPLIB_VOIPTHREAD_VOICECALLERROR					(ERR_JVOIPLIB_VOIPTHREAD_ERRORBASE-1)
#define ERR_JVOIPLIB_VOIPTHREAD_INTERVALACTIONERROR				(ERR_JVOIPLIB_VOIPTHREAD_ERRORBASE-2)

#define ERR_JVOIPLIB_SIGWAIT_ERRORBASE						-2048
#define ERR_JVOIPLIB_SIGWAIT_CANTCREATEPIPE					(ERR_JVOIPLIB_SIGWAIT_ERRORBASE-1)
#define ERR_JVOIPLIB_SIGWAIT_NOTINIT						(ERR_JVOIPLIB_SIGWAIT_ERRORBASE-2)
#define ERR_JVOIPLIB_SIGWAIT_ALREADYINIT					(ERR_JVOIPLIB_SIGWAIT_ERRORBASE-3)

#define ERR_JVOIPLIB_SESSION_ERRORBASE						-3072
#define ERR_JVOIPLIB_SESSION_ALREADYCREATED					(ERR_JVOIPLIB_SESSION_ERRORBASE-1)
#define ERR_JVOIPLIB_SESSION_NOTCREATED						(ERR_JVOIPLIB_SESSION_ERRORBASE-2)
#define ERR_JVOIPLIB_SESSION_CANTREGUSERDEFINPUT				(ERR_JVOIPLIB_SESSION_ERRORBASE-3)
#define ERR_JVOIPLIB_SESSION_CANTREGUSERDEFOUTPUT				(ERR_JVOIPLIB_SESSION_ERRORBASE-4)
#define ERR_JVOIPLIB_SESSION_CANTREGUSERDEFLOCALISATION				(ERR_JVOIPLIB_SESSION_ERRORBASE-5)
#define ERR_JVOIPLIB_SESSION_CANTREGUSERDEFCOMPRESSION				(ERR_JVOIPLIB_SESSION_ERRORBASE-6)
#define ERR_JVOIPLIB_SESSION_CANTREGUSERDEFTRANSMISSION				(ERR_JVOIPLIB_SESSION_ERRORBASE-7)
#define ERR_JVOIPLIB_SESSION_CANTREGUSERDEFMIXER				(ERR_JVOIPLIB_SESSION_ERRORBASE-8)
#define ERR_JVOIPLIB_SESSION_CANTADDDESTINATION					(ERR_JVOIPLIB_SESSION_ERRORBASE-9)
#define ERR_JVOIPLIB_SESSION_CANTDELETEDESTINATION				(ERR_JVOIPLIB_SESSION_ERRORBASE-10)
#define ERR_JVOIPLIB_SESSION_CANTJOINMULTICASTGROUP				(ERR_JVOIPLIB_SESSION_ERRORBASE-11)
#define ERR_JVOIPLIB_SESSION_CANTLEAVEMULTICASTGROUP				(ERR_JVOIPLIB_SESSION_ERRORBASE-12)
#define ERR_JVOIPLIB_SESSION_UNSUPPORTEDRECEIVETYPE				(ERR_JVOIPLIB_SESSION_ERRORBASE-13)
#define ERR_JVOIPLIB_SESSION_CANTSETRECEIVETYPE					(ERR_JVOIPLIB_SESSION_ERRORBASE-14)
#define ERR_JVOIPLIB_SESSION_MULTICASTINGNOTSUPPORTED				(ERR_JVOIPLIB_SESSION_ERRORBASE-15)
#define ERR_JVOIPLIB_SESSION_CANTADDTOACCEPTLIST				(ERR_JVOIPLIB_SESSION_ERRORBASE-16)
#define ERR_JVOIPLIB_SESSION_CANTADDTOIGNORELIST				(ERR_JVOIPLIB_SESSION_ERRORBASE-17)
#define ERR_JVOIPLIB_SESSION_CANTDELETEFROMACCEPTLIST				(ERR_JVOIPLIB_SESSION_ERRORBASE-18)
#define ERR_JVOIPLIB_SESSION_CANTDELETEFROMIGNORELIST				(ERR_JVOIPLIB_SESSION_ERRORBASE-19)
#define ERR_JVOIPLIB_SESSION_ILLEGALINPUTTYPE					(ERR_JVOIPLIB_SESSION_ERRORBASE-20)
#define ERR_JVOIPLIB_SESSION_ILLEGALOUTPUTTYPE					(ERR_JVOIPLIB_SESSION_ERRORBASE-21)
#define ERR_JVOIPLIB_SESSION_ILLEGALLOCALISATIONTYPE				(ERR_JVOIPLIB_SESSION_ERRORBASE-22)
#define ERR_JVOIPLIB_SESSION_ILLEGALCOMPRESSIONTYPE				(ERR_JVOIPLIB_SESSION_ERRORBASE-23)
#define ERR_JVOIPLIB_SESSION_ILLEGALTRANSMISSIONTYPE				(ERR_JVOIPLIB_SESSION_ERRORBASE-24)
#define ERR_JVOIPLIB_SESSION_ILLEGALINPUTSAMPLINGRATE				(ERR_JVOIPLIB_SESSION_ERRORBASE-25)
#define ERR_JVOIPLIB_SESSION_ILLEGALOUTPUTSAMPLINGRATE				(ERR_JVOIPLIB_SESSION_ERRORBASE-26)
#define ERR_JVOIPLIB_SESSION_ILLEGALSAMPLEINTERVAL				(ERR_JVOIPLIB_SESSION_ERRORBASE-27)
#define ERR_JVOIPLIB_SESSION_ILLEGALMIXERTYPE					(ERR_JVOIPLIB_SESSION_ERRORBASE-28)
#define ERR_JVOIPLIB_SESSION_CANTINITUSERDEFVOICEINPUT				(ERR_JVOIPLIB_SESSION_ERRORBASE-29)
#define ERR_JVOIPLIB_SESSION_CANTINITUSERDEFVOICEOUTPUT				(ERR_JVOIPLIB_SESSION_ERRORBASE-30)
#define ERR_JVOIPLIB_SESSION_CANTINITUSERDEFCOMPRESSIONMODULE			(ERR_JVOIPLIB_SESSION_ERRORBASE-31)
#define ERR_JVOIPLIB_SESSION_CANTINITUSERDEFLOCALISATION			(ERR_JVOIPLIB_SESSION_ERRORBASE-32)
#define ERR_JVOIPLIB_SESSION_CANTINITUSERDEFMIXER				(ERR_JVOIPLIB_SESSION_ERRORBASE-33)
#define ERR_JVOIPLIB_SESSION_CANTINITUSERDEFTRANSMISSION			(ERR_JVOIPLIB_SESSION_ERRORBASE-34)
#define ERR_JVOIPLIB_SESSION_USERDEFINPUTISNULL					(ERR_JVOIPLIB_SESSION_ERRORBASE-35)
#define ERR_JVOIPLIB_SESSION_USERDEFOUTPUTISNULL				(ERR_JVOIPLIB_SESSION_ERRORBASE-36)
#define ERR_JVOIPLIB_SESSION_USERDEFLOCALISATIONISNULL				(ERR_JVOIPLIB_SESSION_ERRORBASE-37)
#define ERR_JVOIPLIB_SESSION_USERDEFCOMPRESSIONISNULL				(ERR_JVOIPLIB_SESSION_ERRORBASE-38)
#define ERR_JVOIPLIB_SESSION_USERDEFMIXERISNULL					(ERR_JVOIPLIB_SESSION_ERRORBASE-39)
#define ERR_JVOIPLIB_SESSION_USERDEFTRANSMISSIONISNULL				(ERR_JVOIPLIB_SESSION_ERRORBASE-40)
#define ERR_JVOIPLIB_SESSION_CANTSTARTVOICECALLTHREAD				(ERR_JVOIPLIB_SESSION_ERRORBASE-41)
#define ERR_JVOIPLIB_SESSION_UNUSEDCOMPONENT					(ERR_JVOIPLIB_SESSION_ERRORBASE-42)
#define ERR_JVOIPLIB_SESSION_ILLEGALCOMPONENTTYPE				(ERR_JVOIPLIB_SESSION_ERRORBASE-43)
#define ERR_JVOIPLIB_SESSION_ACTIONFAILEDANDRESTOREFAILED			(ERR_JVOIPLIB_SESSION_ERRORBASE-44)
#define ERR_JVOIPLIB_SESSION_VOICEINPUTDOESNTSUPPORTSAMPINT			(ERR_JVOIPLIB_SESSION_ERRORBASE-45)
#define ERR_JVOIPLIB_SESSION_VOICEOUTPUTDOESNTSUPPORTSAMPINT			(ERR_JVOIPLIB_SESSION_ERRORBASE-46)
#define ERR_JVOIPLIB_SESSION_COMPRESSIONDOESNTSUPPORTSAMPINT			(ERR_JVOIPLIB_SESSION_ERRORBASE-47)
#define ERR_JVOIPLIB_SESSION_MIXERDOESNTSUPPORTSAMPINT				(ERR_JVOIPLIB_SESSION_ERRORBASE-48)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFVOICEINPUTSAMPINT			(ERR_JVOIPLIB_SESSION_ERRORBASE-49)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFVOICEOUTPUTSAMPINT			(ERR_JVOIPLIB_SESSION_ERRORBASE-50)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFCOMPRESSIONSAMPINT			(ERR_JVOIPLIB_SESSION_ERRORBASE-51)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFMIXERSAMPINT				(ERR_JVOIPLIB_SESSION_ERRORBASE-52)
#define ERR_JVOIPLIB_SESSION_VOICEINPUTDOESTSUPPORTINPUTSAMPRATE		(ERR_JVOIPLIB_SESSION_ERRORBASE-53)
#define ERR_JVOIPLIB_SESSION_COMPRESSIONDOESNTSUPPORTINPUTSAMPRATE		(ERR_JVOIPLIB_SESSION_ERRORBASE-54)
#define ERR_JVOIPLIB_SESSION_TRANSMISSIONDOESNTSUPPORTINPUTSAMPRATE		(ERR_JVOIPLIB_SESSION_ERRORBASE-55)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFVOICEININPUTSAMPRATE			(ERR_JVOIPLIB_SESSION_ERRORBASE-56)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFCOMPRESSIONINPUTSAMPRATE		(ERR_JVOIPLIB_SESSION_ERRORBASE-57)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFTRANSMISSIONINPUTSAMPRATE		(ERR_JVOIPLIB_SESSION_ERRORBASE-58)
#define ERR_JVOIPLIB_SESSION_VOICEOUTPUTDOESNTSUPPORTOUTPUTSAMPRATE		(ERR_JVOIPLIB_SESSION_ERRORBASE-59)
#define ERR_JVOIPLIB_SESSION_LOCALISATIONDOESNTSUPPORTOUTPUTSAMPRATE		(ERR_JVOIPLIB_SESSION_ERRORBASE-60)
#define ERR_JVOIPLIB_SESSION_MIXERDOESNTSUPPORTOUTPUTSAMPRATE			(ERR_JVOIPLIB_SESSION_ERRORBASE-61)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFVOICEOUTOUTPUTSAMPRATE		(ERR_JVOIPLIB_SESSION_ERRORBASE-62)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFLOCALISATIONOUTPUTSAMPRATE		(ERR_JVOIPLIB_SESSION_ERRORBASE-63)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFMIXEROUTPUTSAMPRATE			(ERR_JVOIPLIB_SESSION_ERRORBASE-64)
#define ERR_JVOIPLIB_SESSION_VOICEINPUTDOESNTSUPPORTINPUTENCODING		(ERR_JVOIPLIB_SESSION_ERRORBASE-65)
#define ERR_JVOIPLIB_SESSION_COMPRESSIONDOESNTSUPPORTINPUTENCODING		(ERR_JVOIPLIB_SESSION_ERRORBASE-66)
#define ERR_JVOIPLIB_SESSION_TRANSMISSIONDOESNTSUPPORTINPUTENCODING		(ERR_JVOIPLIB_SESSION_ERRORBASE-67)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFVOICEININPUTENCODING			(ERR_JVOIPLIB_SESSION_ERRORBASE-68)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFCOMPRESSIONINPUTENCODING		(ERR_JVOIPLIB_SESSION_ERRORBASE-69)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFTRANSMISSIONINPUTENCODING		(ERR_JVOIPLIB_SESSION_ERRORBASE-70)
#define ERR_JVOIPLIB_SESSION_VOICEOUTPUTDOESNTSUPPORTOUTPUTENCODING		(ERR_JVOIPLIB_SESSION_ERRORBASE-71)
#define ERR_JVOIPLIB_SESSION_LOCALISATIONDOESNTSUPPORTOUTPUTENCODING		(ERR_JVOIPLIB_SESSION_ERRORBASE-72)
#define ERR_JVOIPLIB_SESSION_MIXERDOESNTSUPPORTOUTPUTENCODING			(ERR_JVOIPLIB_SESSION_ERRORBASE-73)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFVOICEOUTOUTPUTENCODING		(ERR_JVOIPLIB_SESSION_ERRORBASE-74)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFLOCALISATIONOUTPUTENCODING		(ERR_JVOIPLIB_SESSION_ERRORBASE-75)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFMIXEROUTPUTENCODING			(ERR_JVOIPLIB_SESSION_ERRORBASE-76)	
#define ERR_JVOIPLIB_SESSION_CANTSAVEUSERDEFINPUTSTATE				(ERR_JVOIPLIB_SESSION_ERRORBASE-77)
#define ERR_JVOIPLIB_SESSION_CANTSAVEUSERDEFOUTPUTSTATE				(ERR_JVOIPLIB_SESSION_ERRORBASE-78)
#define ERR_JVOIPLIB_SESSION_CANTSAVEUSERDEFLOCALISATIONSTATE			(ERR_JVOIPLIB_SESSION_ERRORBASE-79)
#define ERR_JVOIPLIB_SESSION_CANTSAVEUSERDEFMIXERSTATE				(ERR_JVOIPLIB_SESSION_ERRORBASE-80)
#define ERR_JVOIPLIB_SESSION_CANTSAVEUSERDEFTRANSMISSIONSTATE			(ERR_JVOIPLIB_SESSION_ERRORBASE-81)
#define ERR_JVOIPLIB_SESSION_CANTSAVEUSERDEFCOMPRESSIONSTATE			(ERR_JVOIPLIB_SESSION_ERRORBASE-82)
#define ERR_JVOIPLIB_SESSION_USERDEFINEDCREATEFAILED				(ERR_JVOIPLIB_SESSION_ERRORBASE-83)
#define ERR_JVOIPLIB_SESSION_TRANSMISSIONDOESNTSUPPORTSAMPINT			(ERR_JVOIPLIB_SESSION_ERRORBASE-84)
#define ERR_JVOIPLIB_SESSION_CANTSETUSERDEFTRANSSAMPINT				(ERR_JVOIPLIB_SESSION_ERRORBASE-85)
#define ERR_JVOIPLIB_SESSION_DESTRUCTORCALLEDDURINGACTIVESESSION		(ERR_JVOIPLIB_SESSION_ERRORBASE-86)

#define ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE					-4096
#define ERR_JVOIPLIB_SOUNDCARDIO_ALREADYOPENEDFORREADING			(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-1)
#define ERR_JVOIPLIB_SOUNDCARDIO_ALREADYOPENEDFORWRITING			(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-2)
#define ERR_JVOIPLIB_SOUNDCARDIO_CANTOPENDEVICE					(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-3)
#define ERR_JVOIPLIB_SOUNDCARDIO_DEVICECLOSED					(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-4)
#define ERR_JVOIPLIB_SOUNDCARDIO_DEVICENOTOPENEDFORINPUT			(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-5)
#define ERR_JVOIPLIB_SOUNDCARDIO_DRIVERALREADYINIT				(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-6)
#define ERR_JVOIPLIB_SOUNDCARDIO_DRIVERNOTINIT					(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-7)
#define ERR_JVOIPLIB_SOUNDCARDIO_CANTSETDRIVERPARAM				(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-8)
#define ERR_JVOIPLIB_SOUNDCARDIO_CANTSTARTTHREAD				(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-9)
#define ERR_JVOIPLIB_SOUNDCARDIO_DRIVERALREADYREGISTERED			(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-10)
#define ERR_JVOIPLIB_SOUNDCARDIO_DRIVERHASNOINPUTTHREAD				(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-11)
#define ERR_JVOIPLIB_SOUNDCARDIO_DRIVERHASNOOUTPUTTHREAD			(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-12)
#define ERR_JVOIPLIB_SOUNDCARDIO_COULDNTREOPENDEVICE				(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-13)
#define ERR_JVOIPLIB_SOUNDCARDIO_DRIVERSHOULDNTBEUSEDAFTERBADREOPEN		(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-14)
#define ERR_JVOIPLIB_SOUNDCARDIO_ILLEGALMULTIPLYFACTOR				(ERR_JVOIPLIB_SOUNDCARDIO_ERRORBASE-15)

#define ERR_JVOIPLIB_SAMPCONV_ERRORBASE						-5120
#define ERR_JVOIPLIB_SAMPCONV_BADCONVERSIONPARAM				(ERR_JVOIPLIB_SAMPCONV_ERRORBASE-1)

#define ERR_JVOIPLIB_SIMPLETIMER_ERRORBASE					-6144
#define ERR_JVOIPLIB_SIMPLETIMER_CANTSTARTTHREAD				(ERR_JVOIPLIB_SIMPLETIMER_ERRORBASE-1)

#define ERR_JVOIPLIB_RTPTRANS_ERRORBASE						-7168
#define ERR_JVOIPLIB_RTPTRANS_UNSUPPORTEDSAMPLERATE				(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-1)
#define ERR_JVOIPLIB_RTPTRANS_CANTINITRTPSESSION				(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-2)
#define ERR_JVOIPLIB_RTPTRANS_CANTSTARTTHREAD					(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-3)
#define ERR_JVOIPLIB_RTPTRANS_CANTPOLLFORDATA					(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-4)
#define ERR_JVOIPLIB_RTPTRANS_CANTREJOINMULTICASTGROUP				(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-5)
#define ERR_JVOIPLIB_RTPTRANS_CANTREINSTALLDESTINATIONS				(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-6)
#define ERR_JVOIPLIB_RTPTRANS_CANTREINSTALLACCEPTLIST				(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-7)
#define ERR_JVOIPLIB_RTPTRANS_CANTREINSTALLIGNORELIST				(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-8)
#define ERR_JVOIPLIB_RTPTRANS_CANTINCREMENTTIMESTAMP				(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-9)
#define ERR_JVOIPLIB_RTPTRANS_CANTSENDPACKET					(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-10)
#define ERR_JVOIPLIB_RTPTRANS_PACKETTOOLARGE					(ERR_JVOIPLIB_RTPTRANS_ERRORBASE-11)

#define ERR_JVOIPLIB_DPCMCOMP_ERRORBASE						-8192
#define ERR_JVOIPLIB_DPCMCOMP_BADFORMAT						(ERR_JVOIPLIB_DPCMCOMP_ERRORBASE-1)
#define ERR_JVOIPLIB_DPCMCOMP_TOOMUCHDATA					(ERR_JVOIPLIB_DPCMCOMP_ERRORBASE-2)

#define ERR_JVOIPLIB_HRTFLOC_ERRORBASE						-9216
#define ERR_JVOIPLIB_HRTFLOC_UNSUPPORTEDSAMPLERATE				(ERR_JVOIPLIB_HRTFLOC_ERRORBASE-1)

#define ERR_JVOIPLIB_GSMCOMP_ERRORBASE						-10240
#define ERR_JVOIPLIB_GSMCOMP_UNSUPPORTEDSAMPLEINTERVAL				(ERR_JVOIPLIB_GSMCOMP_ERRORBASE-1)
#define ERR_JVOIPLIB_GSMCOMP_UNSUPPORTEDSAMPLERATE				(ERR_JVOIPLIB_GSMCOMP_ERRORBASE-2)
#define ERR_JVOIPLIB_GSMCOMP_CANTSTARTTHREAD					(ERR_JVOIPLIB_GSMCOMP_ERRORBASE-3)

#define ERR_JVOIPLIB_LPCCOMP_ERRORBASE						-11264
#define ERR_JVOIPLIB_LPCCOMP_UNSUPPORTEDSAMPLEINTERVAL				(ERR_JVOIPLIB_LPCCOMP_ERRORBASE-1)
#define ERR_JVOIPLIB_LPCCOMP_UNSUPPORTEDSAMPLERATE				(ERR_JVOIPLIB_LPCCOMP_ERRORBASE-2)
#define ERR_JVOIPLIB_LPCCOMP_CANTSTARTTHREAD					(ERR_JVOIPLIB_LPCCOMP_ERRORBASE-3)

#define ERR_JVOIPLIB_SPEEXCOMP_ERRORBASE					-12288
#define ERR_JVOIPLIB_SPEEXCOMP_UNSUPPORTEDSAMPLEINTERVAL			(ERR_JVOIPLIB_SPEEXCOMP_ERRORBASE-1)
#define ERR_JVOIPLIB_SPEEXCOMP_UNSUPPORTEDSAMPLERATE				(ERR_JVOIPLIB_SPEEXCOMP_ERRORBASE-2)
#define ERR_JVOIPLIB_SPEEXCOMP_CANTSTARTTHREAD					(ERR_JVOIPLIB_SPEEXCOMP_ERRORBASE-2)

#define ERR_JVOIPLIB_FILEIO_ERRORBASE						-13312
#define ERR_JVOIPLIB_FILEIO_NOPARAMS						(ERR_JVOIPLIB_FILEIO_ERRORBASE-1)
#define ERR_JVOIPLIB_FILEIO_CANTOPENFILE					(ERR_JVOIPLIB_FILEIO_ERRORBASE-2)
#define ERR_JVOIPLIB_FILEIO_CANTSEEKFILE					(ERR_JVOIPLIB_FILEIO_ERRORBASE-3)
#define ERR_JVOIPLIB_FILEIO_CANTWRITE						(ERR_JVOIPLIB_FILEIO_ERRORBASE-4)
#define ERR_JVOIPLIB_FILEIO_CHANNELSUNSUPPORTED					(ERR_JVOIPLIB_FILEIO_ERRORBASE-5)
#define ERR_JVOIPLIB_FILEIO_ILLEGALFORMAT					(ERR_JVOIPLIB_FILEIO_ERRORBASE-6)

#endif // JVOIPERRORS_H

