/**
 * @file get-person-attr.c Queries the attributes of a person.
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <libgalago/galago.h>
#include <stdio.h>

int
main(int argc, char **argv)
{
	char *person_id, *attr_name;
	GalagoPerson *person;
	const GValue *value;

	if (argc != 3)
	{
		fprintf(stderr, "Usage: get-person-attr person-id attribute\n");
		exit(1);
	}

	person_id = argv[1];
	attr_name = argv[2];

	galago_init("get-person-attr", GALAGO_INIT_CLIENT);

	person = galago_get_person(person_id, GALAGO_REMOTE, TRUE);

	if (person == NULL)
	{
		fprintf(stderr, "Unknown person %s\n", person_id);
		exit(1);
	}

	value = galago_object_get_attribute(GALAGO_OBJECT(person), attr_name);

	if (value == NULL)
	{
		fprintf(stderr, "Attribute '%s' is not set\n", attr_name);
		exit(1);
	}

	if (G_VALUE_HOLDS(value, G_TYPE_STRING))
	{
		printf("%s\n", g_value_get_string(value));
	}
	else if (G_VALUE_HOLDS(value, G_TYPE_BOOLEAN))
	{
		printf("%s\n", g_value_get_boolean(value) ? "true" : "false");
	}
	else if (G_VALUE_HOLDS(value, G_TYPE_INT))
	{
		printf("%d\n", g_value_get_int(value));
	}
	else
	{
		fprintf(stderr, "Unknown attribute type returned\n");
	}

	return 0;
}
