/**
 * log.c - generic loggin functions
 *
 * Copyright (c) 2004, Daniel Atallah
 * based on the debugging / logging functionality in gaim (http://gaim.sf.net)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "log.h"

#include <stdarg.h>
#include <stdio.h>

static int current_log_level = LOG_ERROR;

void log_print(LogLevel log_level, const char *message, ...) {

	va_list args;
	va_start(args, message);

	if (current_log_level >= log_level) {
		vprintf(message, args);
	}

	va_end(args);
}

int is_loggable(LogLevel log_level) {
	int loggable = 0;
	if (current_log_level >= log_level) {
		loggable = 1;
	}
	return loggable;
}

void set_log_level(LogLevel log_level) {
	current_log_level = log_level;
}
