/**
 * log.h - generic logging functions
 *
 * Copyright (c) 2004, Daniel Atallah
 * based on the debugging / logging functionality in gaim (http://gaim.sf.net)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * logging levels.
 */
typedef enum
{
	LOG_FATAL,   /**< Fatal errors.                  */
	LOG_ERROR,   /**< Errors.                        */
	LOG_WARNING, /**< Warnings.                      */
	LOG_DEBUG,   /**< General debugging Information. */
	LOG_TRACE    /**< General chatter.               */

} LogLevel;


/**
 * Prints the specified text to the the log
 * @param message	the message to be appended to the log
 * @param log_level	the log level at which the message should be printed (if current log level >= log_level
 */
void log_print(LogLevel log_level, const char *message, ...);

/**
 * Sets the log level at which subsequent messages should be logged
 * @param log_level	the new log level
 */
void set_log_level(LogLevel log_level);

/**
 * Check if the current log level allows logging at the specified level
 * @param  log_level	the log level to check for logability
 * @return int		1 if log_level will be logged, 0 if it will not
 */
int is_loggable(LogLevel log_level);
