/***************************************************************************
 *   Copyright (C) 2006 Meni Livne <livne@kde.org>                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef __PHISH_UTIL_URL_H
#define __PHISH_UTIL_URL_H


#include "phish.h"


/** Structure used to represent a URL. */
typedef struct
{
  /** Protocol part of URL */
  char *protocol;

  /** Username part of URL, NULL if none */
  char *user;

  /** Password part of URL, NULL if none */
  char *password;

  /** Host part of URL */
  char *host;

  /** Port part of URL, -1 if none */
  int port;

  /** Path part of URL */
  char *path;

  /** Anchor part of URL (after the '#', like used in the <a name> tag */
  char *anchor;

} phish_util_url_t;


/** Parses a URL.
 *  @param str string representing URL to parse
 *  @param url will be filled with results of parsing URL
 */
phish_result_t phish_util_strToURL(const char *str, phish_util_url_t *url);

/** Checks the URL scheme, i.e. whether it contains a username and whether
 *  the server part contains suspicious characters
 *  @param url URL to check
 *  @param results pointer to phish_url_data_t structure whose relevant
 *                 fields will be filled with results
 */
void phish_util_checkURLScheme(phish_util_url_t *url,
                               phish_url_data_t *results);

/** Initialise a URL structure.
 *  @param url pointer to URL structure to initialise
 */
void phish_util_initURL(phish_util_url_t *url);

/** Frees memory allocated in URL structure
 *  @param url pointer to URL structure to free
 */
void phish_util_deleteURL(phish_util_url_t *url);


#endif /* __PHISH_UTIL_URL_H */

