/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_DEVINF_H_
#define _SML_DEVINF_H_

SmlDevInfDevTyp smlDevInfDevTypeFromString(const char *name, SmlError **error);
const char *smlDevInfDevTypeToString(SmlDevInfDevTyp type, SmlError **error);

SmlDevInf *smlDevInfNew(const char *devid, SmlDevInfDevTyp devtyp, SmlError **error);
SmlDevInf *smlDevInfRef(SmlDevInf *devinf);
void smlDevInfUnref(SmlDevInf *devinf);

const char *smlDevInfGetManufacturer(SmlDevInf *devinf);
void smlDevInfSetManufacturer(SmlDevInf *devinf, const char *man);
const char *smlDevInfGetModel(SmlDevInf *devinf);
void smlDevInfSetModel(SmlDevInf *devinf, const char *model);
const char *smlDevInfGetOEM(SmlDevInf *devinf);
void smlDevInfSetOEM(SmlDevInf *devinf, const char *oem);
const char *smlDevInfGetFirmwareVersion(SmlDevInf *devinf);
void smlDevInfSetFirmwareVersion(SmlDevInf *devinf, const char *firmwareVersion);
const char *smlDevInfGetSoftwareVersion(SmlDevInf *devinf);
void smlDevInfSetSoftwareVersion(SmlDevInf *devinf, const char *softwareVersion);
const char *smlDevInfGetHardwareVersion(SmlDevInf *devinf);
void smlDevInfSetHardwareVersion(SmlDevInf *devinf, const char *hardwareVersion);
const char *smlDevInfGetDeviceID(SmlDevInf *devinf);
void smlDevInfSetDeviceID(SmlDevInf *devinf, const char *devid);
SmlDevInfDevTyp smlDevInfGetDeviceType(SmlDevInf *devinf);
void smlDevInfSetDeviceType(SmlDevInf *devinf, SmlDevInfDevTyp devtyp);
SmlBool smlDevInfSupportsUTC(SmlDevInf *devinf);
void smlDevInfSetSupportsUTC(SmlDevInf *devinf, SmlBool supports);
SmlBool smlDevInfSupportsLargeObjs(SmlDevInf *devinf);
void smlDevInfSetSupportsLargeObjs(SmlDevInf *devinf, SmlBool supports);
SmlBool smlDevInfSupportsNumberOfChanges(SmlDevInf *devinf);
void smlDevInfSetSupportsNumberOfChanges(SmlDevInf *devinf, SmlBool supports);

void smlDevInfAddDataStore(SmlDevInf *devinf, SmlDevInfDataStore *datastore);
unsigned int smlDevInfNumDataStores(SmlDevInf *devinf);
SmlDevInfDataStore *smlDevInfGetNthDataStore(SmlDevInf *devinf, unsigned int nth);

SmlDevInfDataStore *smlDevInfDataStoreNew(const char *sourceRef, SmlError **error);
SmlDevInfDataStore *smlDevInfDataStoreRef(SmlDevInfDataStore *datastore);
void smlDevInfDataStoreUnref(SmlDevInfDataStore *datastore);

const char *smlDevInfDataStoreGetSourceRef(SmlDevInfDataStore *datastore);
void smlDevInfDataStoreSetSourceRef(SmlDevInfDataStore *datastore, const char *sourceref);
const char *smlDevInfDataStoreGetDisplayName(SmlDevInfDataStore *datastore);
void smlDevInfDataStoreSetDisplayName(SmlDevInfDataStore *datastore, const char *displayName);
unsigned int smlDevInfGetMaxGUIDSize(SmlDevInfDataStore *datastore);
void smlDevInfSetMaxGUIDSize(SmlDevInfDataStore *datastore, unsigned int max);
void smlDevInfDataStoreSetRxPref(SmlDevInfDataStore *datastore, const char *contenttype, const char *version);
SmlBool smlDevInfDataStoreGetRxPref(SmlDevInfDataStore *datastore, char **contenttype, char **version);
void smlDevInfDataStoreSetRx(SmlDevInfDataStore *datastore, const char *contenttype, const char *version);
SmlBool smlDevInfDataStoreGetRx(SmlDevInfDataStore *datastore, char **contenttype, char **version);
void smlDevInfDataStoreSetTxPref(SmlDevInfDataStore *datastore, const char *contenttype, const char *version);
SmlBool smlDevInfDataStoreGetTxPref(SmlDevInfDataStore *datastore, char **contenttype, char **version);
void smlDevInfDataStoreSetTx(SmlDevInfDataStore *datastore, const char *contenttype, const char *version);
SmlBool smlDevInfDataStoreGetTx(SmlDevInfDataStore *datastore, char **contenttype, char **version);
void smlDevInfDataStoreSetMemory(SmlDevInfDataStore *datastore, SmlBool shared, unsigned int maxid, unsigned int maxmem);
void smlDevInfDataStoreGetMemory(SmlDevInfDataStore *datastore, SmlBool *shared, unsigned int *maxid, unsigned int *maxmem);
void smlDevInfDataStoreSetSyncCap(SmlDevInfDataStore *datastore, SmlDevInfSyncCap cap, SmlBool supported);
SmlBool smlDevInfDataStoreGetSyncCap(SmlDevInfDataStore *datastore, SmlDevInfSyncCap cap);

SmlBool smlDevInfAssemble(SmlDevInf *devinf, char **data, unsigned int *size, SmlError **error);
SmlCommand *smlDevInfNewResult(SmlCommand *cmd, SmlDevInf *devinf, SmlDevInfVersion version, SmlError **error);
SmlCommand *smlDevInfNewPut(SmlDevInf *devinf, SmlDevInfVersion version, SmlError **error);
SmlCommand *smlDevInfNewGet(SmlDevInfVersion version, SmlError **error);

void smlDevInfConfigureSession(SmlDevInf *devinf, SmlSession *session);

SmlDevInf *smlDevInfParse(const char *data, unsigned int length, SmlError **error);
SmlDevInf *smlDevInfFromResult(SmlCommand *result, SmlError **error);

SmlDevInfCTCapType smlDevInfCTCapTypeFromString(const char *name, SmlError **error);
const char *smlDevInfCTCapTypeToString(SmlDevInfCTCapType type, SmlError **error);

/* this interface enforce the logical structure behind the devinf spec */
/* so we can generate SyncML 1.0, 1.1 and 1.2 devinf from this structure */
/* the CTCap will be assigned to a datastore if CTType and VerCT match */

/* PropParam stuff */

SmlDevInfPropParam *smlDevInfNewPropParam(SmlError **error);
void smlDevInfPropParamSetParamName(        // REQUIRED
			SmlDevInfPropParam *propParam,
			const char *paramName);
void smlDevInfPropParamSetDataType(
			SmlDevInfPropParam *propParam,
			const char *dataType);
void smlDevInfPropParamSetDisplayName(
			SmlDevInfPropParam *propParam,
			const char *displayName);
void smlDevInfPropParamAddValEnum(
			SmlDevInfPropParam *propParam,
			const char *valEnum);

char *smlDevInfPropParamGetParamName(SmlDevInfPropParam *propParam);
char *smlDevInfPropParamGetDataType(SmlDevInfPropParam *propParam);
char *smlDevInfPropParamGetDisplayName(SmlDevInfPropParam *propParam);
unsigned int smlDevInfPropParamNumValEnums(SmlDevInfPropParam *propParam);
char *smlDevInfPropParamGetNthValEnum(
			SmlDevInfPropParam *propParam,
			unsigned int n);

/* Property stuff */

SmlDevInfProperty *smlDevInfNewProperty(SmlError **error);
void smlDevInfPropertySetPropName(         // REQUIRED
			SmlDevInfProperty *property,
			const char *propName);
void smlDevInfPropertySetDataType(
			SmlDevInfProperty *property,
			const char *dataType);
void smlDevInfPropertySetMaxOccur(
			SmlDevInfProperty *property,
			unsigned int maxOccur);
void smlDevInfPropertySetMaxSize(
			SmlDevInfProperty *property,
			unsigned int maxSize);
void smlDevInfPropertySetNoTruncate(
			SmlDevInfProperty *property);
void smlDevInfPropertySetDisplayName(
			SmlDevInfProperty *property,
			const char *displayName);
void smlDevInfPropertyAddValEnum(
			SmlDevInfProperty *property,
			const char *valEnum);
void smlDevInfPropertyAddPropParam(
			SmlDevInfProperty *property,
			SmlDevInfPropParam *propParam);

char *smlDevInfPropertyGetPropName(SmlDevInfProperty *property);
char *smlDevInfPropertyGetDataType(SmlDevInfProperty *property);
unsigned int smlDevInfPropertyGetMaxOccur(SmlDevInfProperty *property);
unsigned int smlDevInfPropertyGetMaxSize(SmlDevInfProperty *property);
SmlBool smlDevInfPropertyGetNoTruncate(SmlDevInfProperty *property);
char *smlDevInfPropertyGetDisplayName(SmlDevInfProperty *property);
unsigned int smlDevInfPropertyNumValEnums(SmlDevInfProperty *property);
char *smlDevInfPropertyGetNthValEnum(
			SmlDevInfProperty *property,
			unsigned int n);
unsigned int smlDevInfPropertyNumPropParams(SmlDevInfProperty *property);
SmlDevInfPropParam *smlDevInfPropertyGetNthPropParam(
			SmlDevInfProperty *property,
			unsigned int n);

/* CTCap stuff */

SmlDevInfContentType *smlDevInfNewContentType(
			const char *cttype,
			const char *verct,
			SmlError **error);
void smlDevInfFreeContentType(SmlDevInfContentType *ct);
SmlDevInfCTCap *smlDevInfNewCTCap(SmlError **error);
void smlDevInfCTCapSetCTType(
			SmlDevInfCTCap *ctcap,
			const char *cttype);     // REQUIRED => NOT NULL
void smlDevInfCTCapSetVerCT(
			SmlDevInfCTCap *ctcap,
			const char *verct);     // REQUIRED => NOT NULL
char *smlDevInfCTCapGetCTType(SmlDevInfCTCap *ctcap);
char *smlDevInfCTCapGetVerCT(SmlDevInfCTCap *ctcap);
void smlDevInfCTCapAddProperty(
			SmlDevInfCTCap *ctcap,
			SmlDevInfProperty *property);
void smlDevInfAppendCTCap(SmlDevInf *devinf, SmlDevInfCTCap *ctcap);

SmlDevInfCTCap *smlDevInfGetCTCap(
			SmlDevInf *devinf,
			SmlDevInfContentType *ct);
unsigned int smlDevInfNumCTCaps(SmlDevInf *devinf);
SmlDevInfCTCap *smlDevInfGetNthCTCap(
			SmlDevInf *devinf,
			unsigned int n);
unsigned int smlDevInfCTCapNumProperties(SmlDevInfCTCap *ctcap);
SmlDevInfProperty *smlDevInfCTCapGetNthProperty(
			SmlDevInfCTCap *ctcap,
			unsigned int n);

/* expire date: 20090120 */
void smlDevInfAddCTCap(SmlDevInf *devinf, SmlDevInfCTCapType type, const char *value) LIBSYNCML_DEPRECATED;
SmlDevInfCTCapType smlDevInfGetNthCTCapType(SmlDevInf *devinf, unsigned int nth) LIBSYNCML_DEPRECATED;
const char *smlDevInfGetNthCTCapValue(SmlDevInf *devinf, unsigned int nth) LIBSYNCML_DEPRECATED;

#endif //_SML_DEVINF_H_
