/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_DEVINF_INTERNALS_H_
#define _SML_DEVINF_INTERNALS_H_

struct SmlDevInf {
	gint refCount;
	SmlDevInfVersion version;
	
	SmlDevInfDevTyp devtyp;
	char *manufacturer;
	char *model;
	char *oem;
	char *softwareVersion;
	char *hardwareVersion;
	char *firmwareVersion;
	char *devid;
	
	SmlBool supportsUTC;
	SmlBool supportsLargeObjs;
	SmlBool supportsNumberOfChanges;

	GList *datastores;

	GList *ctcaps;
};

struct SmlDevInfDataStore {
	gint refCount;
	
	char *sourceref;
	char *displayname;
	unsigned int maxGUIDSize;
	
	char *rxPrefContentType;
	char *rxPrefVersion;
	
	char *rxContentType;
	char *rxVersion;
	
	char *txPrefContentType;
	char *txPrefVersion;
	
	char *txContentType;
	char *txVersion;
	
	SmlBool sharedMem;
	unsigned int maxid;
	unsigned int maxmem;
	
	unsigned int synccap;
};

struct SmlDevInfPropParam {
	char *paramName;
	char *dataType;
	char *displayName;
	GList *valEnums;
};

struct SmlDevInfProperty {
	char *propName;
	char *dataType;
	unsigned int maxOccur;
	unsigned int maxSize;
	unsigned int propSize;
	SmlBool noTruncate;
	char *displayName;
	GList *valEnums;
	GList *propParams;
};

struct SmlDevInfCTCap {
	SmlDevInfContentType *ct;
	GList *properties;
};

struct SmlDevInfContentType {
	char *cttype;
	char *verct;
};

#endif //_SML_DEVINF_INTERNALS_H_
