/* Definition of template class
 *
 * Written 2/8/03 by Clay Dowling
 * Lazarus Internet Development
 */
 
#ifndef _TEMPLATE_H_
#define _TEMPLATE_H_

#ifdef __WIN32__
#if BUILDING_DLL
# define DLLIMPORT __declspec (dllexport)
#else /* Not BUILDING_DLL */
# define DLLIMPORT __declspec (dllimport)
#endif /* Not BUILDING_DLL */
#endif

#ifndef __WIN32__
#define DLLIMPORT
#endif

#include "tree.h"

enum tpl_error {tpl_not_found, tpl_empty, tpl_element_not_found, 
		     tpl_element_empty, tpl_error_external};

enum tpl_node_type {NT_LITERAL, NT_ELEMENT};

struct tpl_node_t {

  enum tpl_node_type type;
  int length;
  char* value;
  
  struct tpl_node_t* next;
    
};

struct tpl_element_node_t {

  char* name;
  long length;
  char* value;
    
};

struct tpl_t {

  char* name;
  struct tpl_node_t* nodes;
  int count;
  
};

struct tpl_engine {

  struct forest* elements;
  struct forest* templates;
  enum tpl_error tplerrno;

};

/* Templatizer Public Functions */

/* Constructor and Destructor Functions*/
DLLIMPORT struct tpl_engine* tpl_engine_new();
DLLIMPORT void tpl_engine_delete(struct tpl_engine*);

/* Load templates from a file.
 * 
 * Arguments:
 * t: Templatizer structure to append these templates to
 * filename: name of the template file
 */
DLLIMPORT void tpl_file_load(struct tpl_engine* t, const char* filename);

/* Substitute the element values for their tags in the compiled template. 
 *
 * Arguments
 * name: template name to compile
 * newname: element name to store the result in
 * append: 0 - replace the existing value, if any
 *         1 - append to the existing value, if any
 */
DLLIMPORT void tpl_parse(struct tpl_engine* t, const char* name, const char* newname, int append);

/* Set the value of the named element to value. */
DLLIMPORT void tpl_element_set(struct tpl_engine* t, const char* name, const char* value);

/* Retrieve the named element. Returns 0 if the element does not exist */
DLLIMPORT char* tpl_element_get(struct tpl_engine* t, const char* name);

/* Templatizer Private Functions */

/* Break a template down into template_node_t elements and load them into 
 * a template_t structure. 
 *
 * buffer: the raw buffer data for a single template
 */
DLLIMPORT struct tpl_t* tpl_compile(char* buffer);

struct tpl_t* tpl_new();
void tpl_delete(struct tpl_t*);
struct tpl_node_t* tpl_node_new();
void tpl_node_delete(struct tpl_node_t*);
struct tpl_element_node_t* tpl_element_node_new();
void tpl_element_node_delete(struct tpl_element_node_t*);

struct tpl_element_node_t* tpl_element_node_get(struct tpl_engine*, const char*);

struct tpl_element_node_t* tpl_parse_private(struct tpl_engine*, const char*);
int tpl_element_compare(const void*, const void*);
DLLIMPORT int tpl_compare(const void*, const void*);

/* Take an array of element nodes and join them into a single 
 * element node.  Made sure the data array is terminated by a NULL pointer
 */
struct tpl_element_node_t* tpl_element_node_join(struct tpl_element_node_t** data);

char* tpl_contents_extract(char* raw, char** name, char** newstart);

#endif
