/* Test the functioning of the template library */

#include <stdio.h>
#include <stdlib.h>
#include "template.h"

int main() {

  struct tpl_engine* engine;
  char base[10];
  char square[10];
  char cube[10];
  char* result;
  int n;

  engine = tpl_engine_new();
  tpl_file_load(engine, "test.tpl");

  for(n=1; n <= 10; n++) {
    sprintf(base, "%4d", n);
    sprintf(square, "%4d", n*n);
    sprintf(cube, "%4d", n*n*n);

    tpl_element_set(engine, "base", base);
    tpl_element_set(engine, "square", square);
    tpl_element_set(engine, "cube", cube);

    tpl_parse(engine, "row", "rows", 1);

  }

  tpl_parse(engine, "grid", "main", 0);
  result = tpl_element_get(engine, "main");

  if (result) puts(result);
  else puts("No element returned.");

  return 0;

}
