/* Declaration for an AVL binary tree.
 * algorithm cribbed from http://home.earthlink.net/~smela1/libdict.html
 */

#ifndef _TREE_H_
#define _TREE_H_

#ifdef __WIN32__
#if BUILDING_DLL
# define DLLIMPORT __declspec (dllexport)
#else /* Not BUILDING_DLL */
# define DLLIMPORT __declspec (dllimport)
#endif /* Not BUILDING_DLL */
#endif

#ifndef __WIN32__
#define DLLIMPORT
#endif

#include <stdio.h>

struct tree_t {

  void* data;
  struct tree_t* left;
  struct tree_t* right;
  struct tree_t* parent;
  int balance;

};

struct forest {

  struct tree_t* root;
  int count;

};

struct forest* forest_new();
void forest_delete(struct forest*, void (*dealloc)(void*));

struct tree_t* tree_new();
DLLIMPORT struct tree_t* tree_insert(struct forest*, void*, int (*compare)(const void*, const void*));

void tree_balance(struct forest*, struct tree_t*, struct tree_t*);

struct tree_t* tree_find(struct forest*, void*, int (*compare)(const void*, const void*));
void tree_print(struct forest*, FILE*, void (*print)(FILE*, const void*));
void tree_print_worker(struct tree_t*, FILE*, void (*print)(FILE*, const void*));
void tree_delete(struct tree_t*, void (*dealloc)(void*));

/* Return a breadth-first span of the tree.  Returns a null-terminated array
 * of the data nodes. */
void** tree_span(struct forest*);

void tree_rotleft(struct forest*, struct tree_t*);
void tree_rotright(struct forest*, struct tree_t*);

#endif
