/*
 *   bezier - Calculate coordinates for PostScript Bzier curves
 *   Copyright (C) 2000 Ulf Jordan
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * The arc parameters alpha and beta are defined from (with positive sign
 * as given by the arrows.
 *
 *                      
 *                \    ___---___    /
 *                 \_--         --_/
 *                  \             /
 *                   \   alpha   /
 *                    \    _    /
 *                     \ _- -_ /
 *                      \v    /<-
 *                       \   /   \  beta
 *                        \ /     |
 *                          ----------------------
 *
 */

#include <math.h>

int 
main (int argc, char **argv)
{
  double alpha,beta,x0,y0,x1,y1,xp0,yp0,xp1,yp1,r1x,r1y,r2x,r2y,r3x,r3y;

  printf ("Alpha: "); scanf ("%le", &alpha);
  printf ("Beta : "); scanf ("%le", &beta);

  /* Do the calculations */
  /* Absolute values of vector and tangent vector of arc */
  x0 = cos (beta);
  y0 = sin (beta);
  x1 = cos (alpha + beta);
  y1 = sin (alpha + beta);
  xp0 = -alpha*sin (beta);
  yp0 = alpha*cos (beta);
  xp1 = -alpha*sin (alpha + beta);
  yp1 = alpha*cos (alpha + beta);
  /* Bzier control points relative to (x0,y0) */
  r1x = xp0/3;
  r1y = yp0/3;
  r3x = x1 - x0;
  r3y = y1 - y0;
  r2x = r3x - xp1/3;
  r2y = r3y - yp1/3;

  /* Present the result */
  printf ("%f %f %f %f %f %f \n", r1x, r1y, r2x, r2y, r3x, r3y);
}
