/*
 *   circle-t-circle - Calculate tangents between two given circles
 *   Copyright (C) 2000 Ulf Jordan
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <math.h>

double
e1 (double R0,double k,double m)
{
  return (k*k*m*m + (1 + k*k)*(R0*R0 - m*m));
}

double
e2 (double R1,double x1,double y1,double k,double m)
{
  return ((k*(m - y1) - x1)*(k*(m - y1) - x1) 
          + (1 + k*k)*(R1*R1 - x1*x1 - (m - y1)*(m - y1)));
}

void 
tpoints (double x1,double y1,double k,double m)
{
  double xt0,xt1,yt0,yt1;

  xt0 = -k*m/(1 + k*k);
  yt0 = k*xt0 + m;
  xt1 = (x1 + k*(y1 - m))/(1 + k*k);
  yt1 = k*xt1 + m;
  printf ("(%f %f) (%f %f)\n", xt0, yt0, xt1, yt1);
}

int 
main (int argc, char **argv)
{
  double R0, x1, y1, R1;
  double k, m, kr1, kr2, km1, km2, k1, k2, k3, k4, m1, m2, m3, m4;
  double tol = 0.01;

  printf ("Parameters of first circle:\n");
  printf ("Radius       R0: "); scanf("%le", &R0);
  printf ("Parameters of second circle:\n");
  printf ("Centre point x1: "); scanf("%le", &x1);
  printf ("             y1: "); scanf("%le", &y1);
  printf ("Radius       R1: "); scanf("%le", &R1);

  /* Do the calculations */
  printf ("+\n");
  if (abs (R1 - R0) == abs(x1))
    {
      /* The circles tangent each other */
      if (y1 == 0)
	{
	  printf("Vertical tangent\n");
	}
      else
	{
	  k = (y1*y1 - (R1 - R0)*(R1 - R0))/(2*x1*y1);
	  m = R0*sqrt (1 + k*k);
	  if (abs (e2 (R1, x1, y1, k, m)) < tol)
	    {
	      printf ("Vertical tangent\nk=%f m=%f ", k, m);
	      tpoints(x1, y1, k, m);
	    }
	}
    } 
  else 
    {
    km1 = -x1*y1/((R1 - R0)*(R1 - R0) - x1*x1);
    kr1 = km1*km1 - ((R1 - R0)*(R1 - R0) - y1*y1)/((R1 - R0)*(R1 - R0) - x1*x1);
    if (kr1 > 0)
      {
	k1 = km1 + sqrt (kr1);
	k2 = km1 - sqrt (kr1);
	m1 = R0*sqrt (1 + k1*k1);
	m2 = R0*sqrt (1 + k2*k2);
	if (abs (e2 (R1, x1, y1, k1, m1)) < tol)
	  {
	    printf ("k=%f m=%f ", k1, m1);
	    tpoints (x1, y1, k1, m1);
	  }
	if (abs (e2 (R1, x1, y1, k2, m2)) < tol)
	  {
	    printf ("k=%f m=%f\n", k2, m2);
	    tpoints (x1, y1, k2, m2);
	  }
      }
    else if (kr1 == 0)
      {
	k = km1;
	m = R0*sqrt (1 + k*k);
	if (abs (e2 (R1, x1, y1, k, m)) < tol)
	  {
	    printf ("k=%f m=%f ", k, m);
	    tpoints (x1, y1, k, m);
	  }
      }
    }
  if (abs (R1 + R0) == abs(x1))
    {
      /* The circles tangent each other */
      if (y1 == 0)
	{
	  printf ("Vertical tangent\n");
	} 
      else
	{
	  k = (y1*y1 - (R1 + R0)*(R1 + R0))/(2*x1*y1);
	  m = -R0*sqrt(1 + k*k);
	  if (abs (e2 (R1, x1, y1, k, m)) < tol)
	    {
	      printf ("Vertical tangent\nk=%f m=%f ", k, m);
	      tpoints (x1, y1, k, m);
	    }
	}
    } 
  else 
    {
      km2 = -x1*y1/((R1 + R0)*(R1 + R0) - x1*x1);
      kr2 = (km2*km2 - ((R1 + R0)*(R1 + R0) - y1*y1)
	     /((R1 + R0)*(R1 + R0) - x1*x1));
      if (kr2 >0)
	{
	  k3 = km2 + sqrt (kr2);
	  k4 = km2 - sqrt (kr2);
	  m3 = -R0*sqrt (1 + k3*k3);
	  m4 = -R0*sqrt (1 + k4*k4);
	  if (abs (e2 (R1, x1, y1, k3, m3)) < tol)
	    {
	      printf ("k=%f m=%f ", k3, m3);
	      tpoints (x1, y1, k3, m3);
	    }
	  if (abs (e2 (R1, x1, y1, k4, m4)) < tol)
	    {
	      printf ("k=%f m=%f ", k4, m4);
	      tpoints (x1, y1, k4, m4);
	    }
	} 
      else if (kr2 == 0)
	{
	  k = km2;
	  m = -R0*sqrt(1 + k*k);
	  if (abs (e2 (R1, x1, y1, k, m)) < tol)
	    {
	      printf ("k=%f m=%f ", k, m);
	      tpoints (x1, y1, k, m);
	    }
	}  
    }
  printf("-\n");
  if (abs (R1 - R0) == abs (x1))
    {
    /* The circles tangent each other */
      if (y1 == 0)
	{
	  printf("Vertical tangent\n");
	}
      else
	{
	  k = (y1*y1 - (R1 - R0)*(R1 - R0))/(2*x1*y1);
	  m = -R0*sqrt(1 + k*k);
	  if (abs (e2 (R1, x1, y1, k, m)) < tol)
	    {
	      printf ("Vertical tangent\nk=%f m=%f ", k, m);
	      tpoints(x1, y1, k, m);
	    }
	}
    } 
  else 
    {
      km1 = -x1*y1/((R1 - R0)*(R1 - R0) - x1*x1);
      kr1 = (km1*km1 - ((R1 - R0)*(R1 - R0) - y1*y1)
	     /((R1 - R0)*(R1 - R0) - x1*x1));
      if (kr1 > 0)
	{
	  k1 = km1 + sqrt (kr1);
	  k2 = km1 - sqrt (kr1);
	  m1 = -R0*sqrt (1 + k1*k1);
	  m2 = -R0*sqrt (1 + k2*k2);
	  if (abs (e2 (R1, x1, y1, k1, m1)) < tol) 
	    {
	      printf ("k=%f m=%f ", k1, m1);
	      tpoints (x1, y1, k1, m1);
	    }
	  if (abs (e2 (R1, x1, y1, k2, m2)) < tol)
	    {
	      printf ("k=%f m=%f ", k2, m2);
	      tpoints (x1, y1, k2, m2);
	    }
	}
      else if (kr1 == 0)
	{
	  k = km1;
	  m = -R0*sqrt(1 + k*k);
	  if (abs (e2 (R1, x1, y1, k, m)) < tol)
	    {
	      printf ("k=%f m=%f ", k, m);
	      tpoints (x1, y1, k, m);
	    }
	}
    }
  if (abs (R1 + R0) == abs (x1))
    {
      /* The circles tangent each other */
      if (y1 == 0)
	{
	  printf ("Vertical tangent\n");
	}
      else
	{
	  k = (y1*y1 - (R1 + R0)*(R1 + R0))/(2*x1*y1);
	  m = R0*sqrt (1 + k*k);
	  if (abs (e2 (R1, x1, y1, k, m)) < tol)
	    {
	      printf ("Vertikal tangent\nk=%f m=%f ", k, m);
	      tpoints (x1, y1, k, m);
	    }
	}
    }
  else
    {
      km2 = -x1*y1/((R1 + R0)*(R1 + R0) - x1*x1);
      kr2 = (km2*km2 - ((R1 + R0)*(R1 + R0) - y1*y1)
	     /((R1 + R0)*(R1 + R0) - x1*x1));
      if (kr2 > 0)
	{
	  k3 = km2 + sqrt (kr2);
	  k4 = km2 - sqrt (kr2);
	  m3 = R0*sqrt (1 + k3*k3);
	  m4 = R0*sqrt (1 + k4*k4);
	  if (abs (e2 (R1, x1, y1, k3, m3)) < tol)
	    {
	      printf ("k=%f m=%f ", k3, m3);
	      tpoints (x1, y1, k3, m3);
	    }
	  if (abs (e2 (R1, x1, y1, k4, m4)) < tol)
	    {
	      printf ("k=%f m=%f ", k4, m4);
	      tpoints(x1, y1, k4, m4);
	    }
	} 
      else if (kr2 == 0)
	{
	  k = km2;
	  m = R0*sqrt (1 + k*k);
	  if (abs (e2 (R1, x1, y1, k, m)) < tol)
	    {
	      printf ("k=%f m=%f ", k, m);
	      tpoints (x1, y1, k, m);
	    }
	}
    }
}
