/*
 *   line-circle - Calculate intersection between a line and a circle
 *   Copyright (C) 2000 Ulf Jordan
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <math.h>

int 
main(int argc, char **argv)
{
  double x0, y0, R, k, m;
  double xm, xr, x1, x2, y1, y2;

  printf ("Parameters of the circle:\n");
  printf ("Centre point x0: "); scanf("%le", &x0);
  printf ("             y0: "); scanf("%le", &y0);
  printf ("Radius        R: "); scanf("%le", &R);
  printf ("Parameters of the line y=kx+m:\n");
  printf ("              k: "); scanf("%le", &k);
  printf ("              m: "); scanf("%le", &m);

  /* Do the calculations */
  xm = (x0 + k*(y0 - m))/(1 + k*k);
  xr = xm*xm + (R*R - x0*x0 - (m - y0)*(m - y0))/(1 + k*k);
  if (xr < 0) 
    {
      printf ("There is no intersection\n");
    }
  else
    {
      x1 = xm - sqrt (xr);
      y1 = k*x1 + m;
      x2 = xm + sqrt (xr);
      y2 = k*x2 + m;
      printf ("Intersection points:\n");
      printf ("(%f %f)\n(%f %f)\n", x1, y1, x2, y2);
    }
}


