// MooDriver - (C) 2006 M.Derezynski
//
// Code based on;
//
// ---
//
// giFTcurs - curses interface to giFT
// Copyright (C) 2001, 2002, 2003 Göran Weinholt <weinholt@dtek.chalmers.se>
// Copyright (C) 2003 Christian Häggström <chm@c00.info>
//

#ifndef MOO_TYPES_H
#define MOO_TYPES_H

#include <glib.h>
#include <map>
#include <vector>
#include <sigc++/sigc++.h>

namespace Moo
{
    // Transfer
    enum TransferState
    {
      XFER_STATE_FINISHED,
      XFER_STATE_RUNNING,
      XFER_STATE_NEGOTIATE,
      XFER_STATE_WAITING,
      XFER_STATE_ESTABLISHING,
      XFER_STATE_INITIATING,
      XFER_STATE_CONNECTING,
      XFER_STATE_QUEUED,
      XFER_STATE_GET_ADDRESS,
      XFER_STATE_GET_STATUS,
      XFER_STATE_NO_USER,
      XFER_STATE_CLOSED,
      XFER_STATE_UNABLE_TO_CONNECT,
      XFER_STATE_ABORTED,
      XFER_STATE_ERROR
    };
    struct Transfer
    {
      bool          upload;
      std::string   user;
      std::string   path;
      unsigned int  queuepos;
      unsigned int  state;
      std::string   error;
      gint64        position;
      gint64        size;
      unsigned int  rate;
    };
    typedef std::pair<std::string, std::string> XFERKey;
    typedef std::map<XFERKey, Transfer> Transfers;

    // Search Result
    typedef std::vector<unsigned int> FileAttrs;
    struct File
    {
        std::string       name;
        gint64            size;
        std::string       ext;
        FileAttrs         attrs;
    };
    typedef std::vector<File> FileList;
    struct SearchResult
    {
        unsigned int      ticket;
        std::string       user;
        bool              slot;
        unsigned int      speed;
        unsigned int      queue;
        FileList          files;
    };

    // Signals
    typedef sigc::signal<void>                            SDisconnected;
    typedef sigc::signal<void>                            SConnected;
    typedef sigc::signal<void, bool, std::string>         SStatusMessage;
    typedef sigc::signal<void, bool, std::string>         SServerState;
    typedef sigc::signal<void, bool, std::string>         SLogin;
    typedef sigc::signal<void, std::string, unsigned int> SSearch;
    typedef sigc::signal<void, SearchResult>              SSearchResult;
    typedef sigc::signal<void, XFERKey, Transfer>         STransferUpdate;

    enum MuseekSearchType
    {
        SEARCH_GLOBAL,
        SEARCH_BUDDIES,
        SEARCH_ROOM
    };

    typedef std::map<std::string, guint> SearchesBySearchT;
    typedef std::map<guint, std::string> SearchesByTicketT;
}

#endif
