/////////////////////////////////////////////////////////////////////////////
// Name:        Config.h
// Purpose:     Configuration
// Author:      Alex Thuering
// Created:     27.03.2003
// RCS-ID:      $Id: Config.h,v 1.43 2008/11/09 19:58:33 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef DS_CONFIG_H
#define DS_CONFIG_H

#include <wx/wx.h>
#include <wx/config.h>

const wxString DEF_VERSION      = wxT("");
const int DEF_LANGUAGE          = -1;
const wxString DEF_VOLUME_NAME  = wxT("DVD");
const long DEF_VIDEO_FORMAT      = 2;
const long DEF_AUDIO_FORMAT      = 2;
const long DEF_CHAPTER_LENGTH    = 10;
const wxString DEF_FILE_BROWSER_DIR 	 = wxT("");
const wxString DEF_FILE_BROWSER_LAST_DIR = wxGetHomeDir();
const wxString DEF_LAST_PROJECT_DIR 	 = wxGetHomeDir();
const wxString DEF_GEN_TEMP_DIR = wxGetHomeDir() + wxFILE_SEP_PATH + _T("dvd");
const bool DEF_REMOVE_TEMP = true;
const bool DEF_VBR = false;
const int DEF_VIDEO_BITRATE = 4500;
const int DEF_AUDIO_BITRATE = 224;
const int DEF_MENU_FRAME_COUNT = 100;
const int DEF_MENU_VIDEO_BITRATE = 6000;
const int DEF_SLIDESHOW_VIDEO_BITRATE = 6000;
#ifdef __WXMSW__
  const bool DEF_PREVIEW_DO        = false;
  const wxString DEF_PREVIEW_CMD   = _T("");
  const wxString DEF_BURN_DEVICE   = _T("");
  const wxString DEF_ADD_ECC_CMD   = _T("\"C:\\Program Files\\dvdisaster\\dvdisaster\" -mRS02 -n dvd -c -i \"$FILE\"");
#else
  const bool DEF_PREVIEW_DO        = true;
  const wxString DEF_PREVIEW_CMD   = _T("xine \"dvd:/$DIR\"");
  const wxString DEF_BURN_DEVICE   = _T("/dev/dvd");
  const wxString DEF_ADD_ECC_CMD   = _T("dvdisaster -mRS02 -n dvd -c -i \"$FILE\"");
#endif
const wxString DEF_SPUMUX_CMD    = _T("spumux \"$FILE_CONF\"");
const wxString DEF_DVDAUTHOR_CMD = _T("dvdauthor -o \"$DIR\" -x \"$FILE_CONF\"");
const wxString DEF_ISO_CMD       = _T("mkisofs -V \"$VOL_ID\" -o \"$FILE\" -dvd-video \"$DIR\"");
const wxString DEF_ISO_SIZE_CMD  = _T("mkisofs -quiet -print-size \"$DIR\"");
const wxString DEF_BURN_SCAN_CMD = _T("dvd+rw-mediainfo $DEVICE");
const wxString DEF_BURN_CMD      = _T("growisofs -V \"$VOL_ID\" -dvd-compat -Z $DEV -dvd-video \"$DIR\" $SPEEDSTR");
const wxString DEF_BURN_ISO_CMD  = _T("growisofs -dvd-compat -Z $DEV=\"$FILE\" -use-the-force-luke=dao:$SIZE $SPEEDSTR");
const bool DEF_GENERATE_DO       = false;
const bool DEF_ISO_DO            = false;
const bool DEF_BURN_DO           = true;
const wxString DEF_BURN_SPEED_OPT= _T("-speed=$SPEED");
const bool DEF_FORMAT_DO         = false;
const wxString DEF_FORMAT_CMD    = _T("dvd+rw-format -force $DEV");
const wxString DEF_ISO_SAVETO = wxGetHomeDir() + wxFILE_SEP_PATH + _T("dvd.iso");
const int DEF_BURN_SPEED      = 0;
const bool DEF_ADD_ECC_DO        = false;
const int DEF_KEY = 0;

#define CONFIG_PROP(name, cfgName, defName)\
  CONFIG_PROP_T(name, cfgName, defName, wxString, wxString)

#define CONFIG_PROP_BOOL(name, cfgName, defName)\
  CONFIG_PROP_T(name, cfgName, defName, bool, long)

#define CONFIG_PROP_INT(name, cfgName, defName)\
  CONFIG_PROP_T(name, cfgName, defName, int, long)

#define CONFIG_PROP_T(name, cfgName, defName, cfgType, cfgType2)\
  cfgType Get##name(bool def = false)\
  { return def ? (cfgType2) defName : cfg->Read(cfgName, (cfgType2) defName); }\
  void Set##name(cfgType value)\
  {\
    wxLogNull log;\
    if (value == defName) cfg->DeleteEntry(cfgName);\
    else cfg->Write(cfgName, value);\
  }

class Config
{
  public:
    void Init() { cfg = wxConfig::Get(); }
    bool Flush() { return cfg->Flush(); }
    bool DeleteAll() { return cfg->DeleteAll(); }
    bool DeleteGroup(wxString group) { return cfg->DeleteGroup(group); }
    
    wxRect GetMainWinLocation();
    void SetMainWinLocation(wxRect rect);
	
	CONFIG_PROP(Version,  _T("Version"), DEF_VERSION)
	CONFIG_PROP_INT(Language, _T("Interface/Language"), DEF_LANGUAGE)
    CONFIG_PROP(DefVolumeName, _T("Interface/DefVolumeName"), DEF_VOLUME_NAME)
	CONFIG_PROP_INT(DefVideoFormat, _T("Interface/DefVideoFormat"), DEF_VIDEO_FORMAT)
	CONFIG_PROP_INT(DefAudioFormat, _T("Interface/DefAudioFormat"), DEF_AUDIO_FORMAT)
	CONFIG_PROP_INT(DefChapterLength, _T("Interface/DefChapterLength"), DEF_CHAPTER_LENGTH)
	CONFIG_PROP(FileBrowserDir,  _T("Interface/FileBrowserDir"), DEF_FILE_BROWSER_DIR)
	CONFIG_PROP(FileBrowserLastDir,  _T("Interface/FileBrowserLastDir"), DEF_FILE_BROWSER_LAST_DIR)
	CONFIG_PROP(LastProjectDir,  _T("Interface/LastProjectDir"), DEF_LAST_PROJECT_DIR)
	
	CONFIG_PROP(TempDir, _T("Generate/TempDir"), DEF_GEN_TEMP_DIR)
	CONFIG_PROP_BOOL(RemoveTempFiles, _T("Generate/RemoveTempFiles"), DEF_REMOVE_TEMP)
	CONFIG_PROP_INT(Vbr, _T("Generate/Vbr"), DEF_VBR)
	CONFIG_PROP_INT(VideoBitrate, _T("Generate/VideoBitrate"), DEF_VIDEO_BITRATE)
	CONFIG_PROP_INT(AudioBitrate, _T("Generate/AudioBitrate"), DEF_AUDIO_BITRATE)
	CONFIG_PROP_INT(MenuFrameCount,_T("Generate/MenuFrameCount"), DEF_MENU_FRAME_COUNT)
	CONFIG_PROP_INT(MenuVideoBitrate, _T("Generate/MenuVideoBitrate"), DEF_MENU_VIDEO_BITRATE)
    CONFIG_PROP_INT(SlideshowVideoBitrate, _T("Generate/SlideshowVideoBitrate"), DEF_SLIDESHOW_VIDEO_BITRATE)
	CONFIG_PROP(SpumuxCmd,  _T("Generate/SpumuxCmd"), DEF_SPUMUX_CMD)
	CONFIG_PROP(DvdauthorCmd, _T("Generate/DvdauthorCmd"), DEF_DVDAUTHOR_CMD)
	
	CONFIG_PROP_BOOL(PreviewDo, _T("Preview/Do"), DEF_PREVIEW_DO)
	CONFIG_PROP(PreviewCmd, _T("Preview/Cmd"), DEF_PREVIEW_CMD)
	
	CONFIG_PROP_BOOL(GenerateDo, _T("Generate/Do"), DEF_GENERATE_DO)
	
	CONFIG_PROP_BOOL(IsoDo, _T("Iso/Do"), DEF_ISO_DO)
	CONFIG_PROP(IsoCmd, _T("Iso/Cmd"), DEF_ISO_CMD)
	CONFIG_PROP(IsoSizeCmd, _T("Iso/SizeCmd"), DEF_ISO_SIZE_CMD)
	CONFIG_PROP(IsoSaveTo,  _T("Iso/SaveTo"), DEF_ISO_SAVETO)
	
	CONFIG_PROP_BOOL(BurnDo, _T("Burn/Do"), DEF_BURN_DO)
	CONFIG_PROP(BurnCmd, _T("Burn/Cmd"), DEF_BURN_CMD)
	CONFIG_PROP(BurnISOCmd, _T("Burn/ISOCmd"), DEF_BURN_ISO_CMD)
	CONFIG_PROP(BurnDevice, _T("Burn/Device"), DEF_BURN_DEVICE)
	CONFIG_PROP(BurnScanCmd, _T("Burn/ScanSmd"), DEF_BURN_SCAN_CMD)
	CONFIG_PROP(BurnSpeedOpt, _T("Burn/SpeedOpt"), DEF_BURN_SPEED_OPT)
	CONFIG_PROP_INT(BurnSpeed, _T("Burn/Speed"), DEF_BURN_SPEED)
	
	CONFIG_PROP_BOOL(FormatDo, _T("Burn/FormatDo"), DEF_FORMAT_DO)
	CONFIG_PROP(FormatCmd, _T("Burn/FormatCmd"), DEF_FORMAT_CMD)
	
	CONFIG_PROP_BOOL(AddECCDo, _T("AddECC/Do"), DEF_ADD_ECC_DO)
	CONFIG_PROP(AddECCCmd, _T("AddECC/Cmd"), DEF_ADD_ECC_CMD)
	
    CONFIG_PROP_INT(Key, _T("Burn/Key"), DEF_KEY)
    
  protected:
    wxConfigBase* cfg;
};

extern Config s_config;

#endif //DS_CONFIG_H
