/////////////////////////////////////////////////////////////////////////////
// Name:        ProgressDlg.h
// Purpose:     Progress of generation/burning dialog
// Author:      Alex Thuering
// Created:     14.08.2004
// RCS-ID:      $Id: ProgressDlg.h,v 1.17 2008/10/26 20:01:32 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef PROGRESS_DLG_H
#define PROGRESS_DLG_H

#include "DVD.h"
#include "BurnDlg.h"

// begin wxGlade: dependencies
// end wxGlade

class ProgressDlg : public wxDialog {
public:
    // begin wxGlade: ProgressDlg::ids
    enum {
        HIDE_BT_ID = 1001,
        ICONIZE_BT_ID = 1002
    };
    // end wxGlade

public:
	ProgressDlg(wxWindow* parent, bool autoStart = false);
	// starts the generating of DVD
	void Start(BurnDlg* burnDlg, DVD* dvd);

	// add the given message to summary textbox
	void AddSummaryMsg(const wxString& message,
			const wxString& details = wxEmptyString,
			const wxColour& colour = wxNullColour);
	// add the given message to details textbox
	void AddDetailMsg(const wxString& message,
			const wxColour& colour = wxNullColour);
	// add the given text to details textbox
	void AddDetailText(const wxString& text);

	// sets the step count of generating process
	void SetSteps(int value) {
		m_gauge->SetRange(value*100);
		m_step = 0;
	}
	// increments the step
	void IncStep() {
		m_step ++;
		m_subStep = 0;
		UpdateGauge();
	}

	// sets the sub-step count of current step
	void SetSubSteps(int value) {
		m_subStepCount = value;
		m_subStep = 0;
	}
	// sets the sub-step
	void SetSubStep(int value) {
		m_subStep = value;
		UpdateGauge();
	}
	// increments the sub-step
	void IncSubStep(int value = 1) {
		SetSubStep(GetSubStep() + value);
	}
	// returns the sub-step
	int GetSubStep() {
		return m_subStep;
	}

	bool IsCanceled();

private:
    // begin wxGlade: ProgressDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    // begin wxGlade: ProgressDlg::attributes
    wxStaticText* m_summaryLabel;
    wxTextCtrl* m_summaryText;
    wxGauge* m_gauge;
    wxStaticText* m_detailsLabel;
    wxTextCtrl* m_detailsText;
    wxButton* m_detailsBt;
    wxButton* m_minimizeBt;
    wxButton* m_cancelBt;
    // end wxGlade
	wxSizer* m_panelSizer;
	
	bool m_autoStart;
	int m_step;
	int m_subStepCount;
	int m_subStep;
	void UpdateGauge();

	void Failed(const wxString& message);
	void FailedExec(const wxString& command);
	void End();

	bool m_cancel;
	void OnCancel(wxCommandEvent& WXUNUSED(event));
	wxString m_detailsBtLabel;
	void OnHideDetails(wxCommandEvent& WXUNUSED(event));
	void OnMinimize(wxCommandEvent& WXUNUSED(event));

	wxWindowDisabler* m_winDisabler;
	void Run(BurnDlg* burnDlg, DVD* dvd);
	bool GenerateMenu(Menu* menu, const wxString& menuFile,
			AudioFormat audioFormat, wxString audioFile);
    bool GenerateSlideshow(Slideshow* slideshow, const wxString& vobFile, AudioFormat audioFormat);
	bool Transcode(const StreamArray& streams, const wxString& mpegFile,
			const wxArrayString& audioFiles, const wxString& vobFile);
	bool MultiplexSubtitles(const wxString& vobFile, TextSub* textSub,
			const wxString& resultFile);
	/** removes given file and print error message if it failed */
	bool DeleteFile(wxString fname);
	/** removes given directory and all files in it */
	bool DeleteDir(wxString dir, bool subdirs = false);
	/** removes given temporary directory and all temporary files in it */
	bool DeleteTempDir(wxString dir);
	/** executes given command */
	bool Exec(wxString command, wxString inputFile = wxEmptyString,
			wxString outputFile = wxEmptyString);

private:
	DECLARE_EVENT_TABLE()
};

#endif // PROGRESS_DLG_H
