/////////////////////////////////////////////////////////////////////////////
// Name:        SettingsDlg.cpp
// Purpose:     Setting Dlg
// Author:      Alex Thuering
// Created:     27.03.2004
// RCS-ID:      $Id: SettingsDlg.cpp,v 1.35 2008/11/01 10:45:33 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#include "SettingsDlg.h"
#include "Config.h"
#include "Languages.h"
#include "DVD.h"
#include <wx/notebook.h>

enum {
  FILE_BROWSER_CHOICE_ID = 7900,
};

BEGIN_EVENT_TABLE(SettingsDlg, wxPropDlg)
	EVT_CHOICE(FILE_BROWSER_CHOICE_ID, SettingsDlg::OnChangeFileBrowserDir)
END_EVENT_TABLE()

SettingsDlg::SettingsDlg(wxWindow* parent):
 wxPropDlg(parent)
{
  Create(true);
  SetTitle(_("Settings"));
  SetSize(600,-1);
  Center();
}

void SettingsDlg::CreatePropPanel(wxSizer* sizer)
{
  bool def = sizer == NULL;
  wxNotebook* notebook = NULL;
  if (sizer) {
	  notebook = new wxNotebook(this, -1);
	  sizer->Add(notebook, 0, wxEXPAND);
  }
  
  // ----------- Interface Tab Sizers ------------- //
  wxBoxSizer* interfaceSizer = NULL;
  wxFlexGridSizer* interfaceGrid = NULL;
  if (sizer) {
	wxPanel* interfacePanel = new wxPanel(notebook, -1);
    notebook->AddPage(interfacePanel, _("Interface"));
	propWindow = interfacePanel;
	
	interfaceSizer = new wxBoxSizer(wxVERTICAL);
	interfacePanel->SetAutoLayout(true);
	interfacePanel->SetSizer(interfaceSizer);
	
    interfaceGrid = new wxFlexGridSizer(2, 2, 4, 16);
	interfaceGrid->AddGrowableCol(1);
	interfaceSizer->Add(interfaceGrid, 1, wxEXPAND|wxALL, 10);
  }
  
  // -------------- Interface Tab ----------------- //
  wxString lang = GetLangName(s_config.GetLanguage());
  AddChoiceProp(interfaceGrid, _("Language:"), lang, GetLangNames());
  AddTextProp(interfaceGrid, _("Default volume name:"), s_config.GetDefVolumeName(def));
  int vf = s_config.GetDefVideoFormat() >= 2 ? s_config.GetDefVideoFormat() - 2 : 0;
  wxString videoFormat = DVD::GetVideoFormatLabels()[vf];
  AddChoiceProp(interfaceGrid, _("Default video format:"), videoFormat, DVD::GetVideoFormatLabels());
  int af = s_config.GetDefAudioFormat() >= 2 ? s_config.GetDefAudioFormat() - 2 : 0;
  wxString audioFormat = DVD::GetAudioFormatLabels()[af];
  AddChoiceProp(interfaceGrid, _("Default audio format:"), audioFormat, DVD::GetAudioFormatLabels());
  AddSpinProp(interfaceGrid, _("Default chapter length:"), s_config.GetDefChapterLength(def), 1, 100, 60);
  // File Browser start directory
  wxString fbDir = s_config.GetFileBrowserDir();
  const wxString fbChoices[] = { _("Last directory"), _("Custom")};
  wxSizer* fbSizer = AddChoiceProp(interfaceGrid, _("File Browser start directory:"),
		  fbChoices[fbDir.IsEmpty() ? 0 : 1], wxArrayString(2, fbChoices),
		  100, false, FILE_BROWSER_CHOICE_ID);
  if (fbSizer)
	  fbSizer->AddSpacer(4);
  AddDirectoryProp(fbSizer, wxT(""), fbDir);
  if (fbSizer) {
	  m_directoryEdit = (wxTextCtrl*) GetLastControl();
	  m_directorySelectButton = (wxButton*) this->FindWindowByName(
			  wxString::Format(wxT("SelectDirButton_%d"), GetLastControlIndex()));
  }
  m_directoryEdit->Enable(!fbDir.IsEmpty());
  m_directorySelectButton->Enable(!fbDir.IsEmpty());
  
  // -------------- Core Tab Sizers ----------------- //
  wxBoxSizer* coreSizer = NULL;
  wxFlexGridSizer* coreGrid = NULL;
  wxBoxSizer* debugSizer = NULL;
  if (sizer) {
	wxPanel* interfacePanel = new wxPanel(notebook, -1);
    notebook->AddPage(interfacePanel, _("Core"));
	propWindow = interfacePanel;
	
	coreSizer = new wxBoxSizer(wxVERTICAL);
	interfacePanel->SetAutoLayout(true);
	interfacePanel->SetSizer(coreSizer);
	
    coreGrid = new wxFlexGridSizer(2, 2, 4, 16);
	coreGrid->AddGrowableCol(1);
	coreSizer->Add(coreGrid, 1, wxEXPAND|wxTOP|wxLEFT|wxRIGHT, 10);
	
	debugSizer = new wxBoxSizer(wxVERTICAL);
	coreSizer->Add(debugSizer, 0, wxEXPAND|wxBOTTOM|wxLEFT|wxRIGHT, 10);
  }
  
  // ----------------- Core Tab -------------------- //
  AddSpinProp(coreGrid, _("Frame count of menu:"), s_config.GetMenuFrameCount(def), 1, 9999, 80);
  AddSpinProp(coreGrid, _("Menu video bitrate:"), s_config.GetMenuVideoBitrate(def), 1, 9999999, 80);
  AddSpinProp(coreGrid, _("Slideshow video bitrate:"), s_config.GetSlideshowVideoBitrate(def), 1, 9999999, 80);
  AddTextProp(coreGrid, _("Spumux command:"), s_config.GetSpumuxCmd(def));
  AddTextProp(coreGrid, _("Dvdauthor command:"), s_config.GetDvdauthorCmd(def));
  AddTextProp(coreGrid, _("Preview command:"), s_config.GetPreviewCmd(def));
  AddTextProp(coreGrid, _("Create ISO command:"), s_config.GetIsoCmd(def));
  AddTextProp(coreGrid, _("Burn command:"), s_config.GetBurnCmd(def));
  AddTextProp(coreGrid, _("Burn ISO command:"), s_config.GetBurnISOCmd(def));
  AddTextProp(coreGrid, _("Add ECC command:"), s_config.GetAddECCCmd(def));
  AddTextProp(coreGrid, _("Format command:"), s_config.GetFormatCmd(def));
  
  wxSizer* grpSizer = BeginGroup(debugSizer, _("Debug"));
  AddCheckProp(grpSizer, _("Don't remove temp files"), !s_config.GetRemoveTempFiles(def));
}

bool SettingsDlg::SetValues()
{
  int i=0;
  if (GetLangCode(GetInt(i++)) != s_config.GetLanguage())
  {
	s_config.SetLanguage(GetLangCode(GetInt(i-1)));
	wxMessageBox(
	  _("Language change will not take effect until DVDStyler is restarted"),
	  GetTitle(), wxOK|wxICON_INFORMATION, this);
  }
  s_config.SetDefVolumeName(GetString(i++));
  s_config.SetDefVideoFormat(GetInt(i++)+2);
  s_config.SetDefAudioFormat(GetInt(i++)+2);
  s_config.SetDefChapterLength(GetInt(i++));
  i++;
  s_config.SetFileBrowserDir(GetString(i++));
  s_config.SetMenuFrameCount(GetInt(i++));
  s_config.SetMenuVideoBitrate(GetInt(i++));
  s_config.SetSlideshowVideoBitrate(GetInt(i++));
  s_config.SetSpumuxCmd(GetString(i++));
  s_config.SetDvdauthorCmd(GetString(i++));
  s_config.SetPreviewCmd(GetString(i++));
  s_config.SetIsoCmd(GetString(i++));
  s_config.SetBurnCmd(GetString(i++));
  s_config.SetBurnISOCmd(GetString(i++));
  s_config.SetAddECCCmd(GetString(i++));
  s_config.SetFormatCmd(GetString(i++));
  s_config.SetRemoveTempFiles(!GetBool(i++));
  return true;
}

void SettingsDlg::OnChangeFileBrowserDir(wxCommandEvent& evt) {
	m_directoryEdit->SetValue(evt.GetSelection() == 0 ? wxT("") : wxGetHomeDir());
	m_directoryEdit->Enable(evt.GetSelection() == 1);
	m_directorySelectButton->Enable(evt.GetSelection() == 1);
}
