/////////////////////////////////////////////////////////////////////////////
// Name:        mediaenc.h
// Purpose:     Media Encoder Interface
// Author:      Alex Thuering
// Created:     24.02.2007
// RCS-ID:      $Id: mediaenc.h,v 1.3 2008/05/18 15:59:06 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef WX_MEDIA_ENCODER_H
#define WX_MEDIA_ENCODER_H

#include <wx/image.h>

enum VideoFormat {
	vfNONE = 0,
	vfCOPY,
	vfPAL,
	vfNTSC
};

enum AudioFormat {
	afNONE = 0,
	afCOPY,
	afMP2,
	afAC3
};

enum SubtitleFormat {
	sfNONE = 0,
	sfCOPY,
	sfDVD
};

class wxMediaEncoder {
  public:
	virtual ~wxMediaEncoder() {}
	virtual bool BeginEncode(const wxString& fileName, VideoFormat videoFormat,
			AudioFormat audioFormat, int videoBitrate = 6000) = 0;
	virtual bool EncodeImage(wxImage image, int frames = 1) = 0;
	virtual void EndEncode() = 0;
};

#endif // WX_MEDIA_ENCODER_H
