/////////////////////////////////////////////////////////////////////////////
// Name:        mediaenc_ffmpeg.h
// Purpose:     FFMPEG Media Encoder
// Author:      Alex Thuering
// Created:     04.08.2007
// RCS-ID:      $Id: mediaenc_ffmpeg.h,v 1.4 2008/10/26 19:42:07 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef WX_FFMPEG_MEDIA_ENCODER_H
#define WX_FFMPEG_MEDIA_ENCODER_H

#include "mediaenc.h"

struct AVFormatContext;
struct AVStream;
struct AVFrame;
struct SwsContext;

class wxFfmpegMediaEncoder: public wxMediaEncoder {
  public:
    wxFfmpegMediaEncoder();
    ~wxFfmpegMediaEncoder();
    
    bool BeginEncode(const wxString& fileName, VideoFormat videoFormat,
    		AudioFormat audioFormat, int videoBitrate = 6000);
    bool EncodeImage(wxImage image, int frames = 1);
    void EndEncode();
    
    static wxString GetBackendVersion();
    
  private:
    AVFormatContext* m_outputCtx;
    AVStream* m_videoStm;
    AVStream* m_audioStm;
    bool addVideoStream(int codecId, VideoFormat videoFormat, int videoBitrate);
    bool addAudioStream(int codecId);
    
    int16_t* m_samples;
    uint8_t* m_audioOutbuf;
    bool OpenAudioEncoder();
    void CloseAudioEncoder();
    
    AVFrame* m_picture;
    SwsContext* m_imgConvertCtx;
    uint8_t* m_videoOutbuf;
    bool OpenVideoEncoder();
    void CloseVideoEncoder();
    
    void getAudioFrame(int nbChannels);
    bool writeAudioFrame();
    /** writes m_picture */
    bool writeVideoFrame();
};

#endif // WX_FFMPEG_MEDIA_ENCODER_H
