/////////////////////////////////////////////////////////////////////////////
// Name:        mediatrc.h
// Purpose:     Media Transcoder Interface
// Author:      Alex Thuering
// Created:     26.04.2008
// RCS-ID:      $Id: mediatrc.h,v 1.4 2008/11/09 19:56:43 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef WX_MEDIA_TRANSCODER_H
#define WX_MEDIA_TRANSCODER_H

#include "mediaenc.h"
#include "wx/dynarray.h"

class wxMediaTranscoder {
public:
	virtual ~wxMediaTranscoder() {}
	/** Adds input file. */
	virtual bool AddInputFile(const wxString& fileName, bool disableVideo = false,
			bool disableAudio = false, bool disableSubtitle = false) = 0;
	/** Sets output file and video/audio/subtitle formats. */
	virtual bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, AudioFormat audioFormat,
		SubtitleFormat subtitleFormat, int videoBitrate = 6000, bool vbr = false, int audioBitrate = 224) = 0;
	/** Sets output file and video/audio/subtitle formats. */
	virtual bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, wxArrayInt audioFormats,
		wxArrayInt subtitleFormats, int videoBitrate = 6000, bool vbr = false, int audioBitrate = 224) = 0;
	/** Starts transcoding. */
	virtual bool Run(bool& canceled) = 0;
	/** Ends ttanscoding and closes all fiies. */
	virtual void End() = 0;
};

#endif // WX_MEDIA_TRANSCODER_H
