/* Copyright 2003 Bart Vandewoestyne <Bart.Vandewoestyne AT pandora.be>
 *
 *  This file is part of gmms.
 *
 *  Gmms is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Gmms is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Gmms; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* http://developer.gnome.org/doc/GGAD/sec-containers.html */

#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>

#include "mms_lib.h"
#include "mms_gui.h"

// Uncomment this if you're not debugging...
#define DEBUG



/*
 * The thread for downloading the MMS-stream
 */
void *mms_download_thread(void *args)
{
  gchar *filename;  /* the filename to store to */
  gchar *mms_url;   /* the MMS-url to download from */
  gchar buffer[256];  /* TODO: how to make this non-256-dependant and allocate
                         only the space we need ??? */
      
  filename = (gchar *)gtk_entry_get_text(GTK_ENTRY (filename_textfield));
  mms_url = (gchar *)gtk_entry_get_text(GTK_ENTRY (mms_url_textfield));
  //g_sprintf() is only since GTK version 2.2
  sprintf(buffer,
	  "Getting MMS-stream from URL:\n%s\nand writing to file:\n%s\n",
	  (gchar *)gtk_entry_get_text(GTK_ENTRY (mms_url_textfield)),
	  (gchar *)gtk_entry_get_text(GTK_ENTRY (filename_textfield)));
  
  gdk_threads_enter();  // acquire the GTK+ lock
  gtk_text_buffer_insert_at_cursor (log_buffer, buffer, -1);
  gdk_threads_leave();  // release the GTK+ lock

  get_mms_stream (mms_url, filename);
  
  return NULL;
}


/*
 * The thread that pulses the progressbar
 */
/*
void *pulse_bar_thread(void *args)
{
  while (!stopped) {
    gtk_progress_bar_pulse(GTK_PROGRESS_BAR (pbar));
  }
  return NULL;
}
*/


/*
 * Bye bye window!
 */
static gboolean delete_event( GtkWidget *widget,
                              GdkEvent  *event,
                              gpointer   data )
{
    gtk_main_quit();
    return FALSE;
}


/*
 * When pressing the 'Go!' button, a new thread is started within which
 * we download the MMS-content from the stream.
 */
void go_clicked( GtkWidget *widget,
		 gpointer   data )
{
  GError *error = NULL;

  stopped = FALSE;

  /* Create the MMS download thread */
  if (!g_thread_create(mms_download_thread, NULL, FALSE, &error))
    {
      gtk_text_buffer_insert_at_cursor (log_buffer,
					"Failed to create MMS-download thread!\n", -1);
      
      g_printerr ("Failed to create MMS-download thread: %s\n",
		  error->message);
    }
  /* Create thread that pulses progressbar */
  /*
  if (!g_thread_create(pulse_bar_thread, NULL, FALSE, &error))
    {
      g_printerr ("Failed to create progress bar pulse thread: %s\n",
          error->message);
    }
  */
}


/*
 * Filename should be set when pressing 'OK'-button.
 */
void file_ok_sel( GtkWidget *widget,
		  gpointer data )
{
  GtkWidget *fs = (GtkWidget *) data;

  gtk_entry_set_text(GTK_ENTRY (filename_textfield),
		     gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  gtk_widget_destroy (fs);
}


/*
 * Pressing the 'Browse...' button should give us a FileSelection.
 */
void browse_button_clicked( GtkWidget *widget,
			    gpointer   data )
{
  GtkWidget *file_selection;
  
  file_selection = gtk_file_selection_new ("Save stream as...");
  g_signal_connect (G_OBJECT (file_selection), "destroy",
		    G_CALLBACK (gtk_widget_destroy), (gpointer) file_selection);
  g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (file_selection)->ok_button),
	"clicked", G_CALLBACK (file_ok_sel), (gpointer) file_selection);
  g_signal_connect_swapped (G_OBJECT (GTK_FILE_SELECTION (file_selection)->cancel_button),
	"clicked", G_CALLBACK (gtk_widget_destroy), G_OBJECT(file_selection));
  gtk_widget_show(file_selection);
}


/*
 * Stop downloading.
 */
void stop_clicked( GtkWidget *widget,
		   gpointer   data )
{
  gtk_text_buffer_insert_at_cursor(log_buffer,
				   "Stopped downloading MMS-stream.\n",
				   -1);
  stopped = TRUE;
}


GtkWidget *create_mms_url_widget(void)
{
  GtkWidget *box;
  GtkWidget *mms_url_label;
  
  box = gtk_hbox_new (FALSE, 2);
  
  mms_url_label = gtk_label_new("MMS URL:");
  gtk_box_pack_start (GTK_BOX (box), mms_url_label, FALSE, FALSE, 3);
  
  mms_url_textfield = gtk_entry_new();
  gtk_entry_set_width_chars(GTK_ENTRY (mms_url_textfield), 50);
#ifdef DEBUG
  gtk_entry_set_text(GTK_ENTRY (mms_url_textfield),
		     "mms://stream04.pandora.be/stubrubreed");
#endif
  gtk_box_pack_start (GTK_BOX (box), mms_url_textfield, FALSE, FALSE, 3);
  
  gtk_widget_show_all (box);
  
  return box;
}


GtkWidget *create_filename_widget(void)
{
  GtkWidget *box;
  GtkWidget *filename_label;
  GtkWidget *browse_button;
  
  box = gtk_hbox_new (FALSE, 2);
  
  filename_label = gtk_label_new("File to save to:");
  gtk_box_pack_start (GTK_BOX (box), filename_label, FALSE, FALSE, 3);
  
  filename_textfield = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY (filename_textfield),
		     "my_gmms_file.asf");
  gtk_box_pack_start (GTK_BOX (box), filename_textfield, FALSE, FALSE, 3);

  browse_button = gtk_button_new_with_label("Browse...");
  g_signal_connect (G_OBJECT (browse_button), "clicked",
	G_CALLBACK (browse_button_clicked), NULL);
  gtk_box_pack_start (GTK_BOX (box), browse_button, FALSE, FALSE, 3);
  
  gtk_widget_show_all (box);
  
  return box;
}


GtkWidget *create_buttons_widget(void)
{
  GtkWidget *box;
  GtkWidget *go_button;
  GtkWidget *stop_button;
  
  box = gtk_hbox_new (FALSE, 2);
  
  go_button = gtk_button_new_with_label("Go!");
  g_signal_connect (G_OBJECT (go_button), "clicked",
	G_CALLBACK (go_clicked), NULL);
  gtk_box_pack_start (GTK_BOX (box), go_button, TRUE, FALSE, 3);
  
  stop_button = gtk_button_new_with_label("Stop!");
  g_signal_connect (G_OBJECT (stop_button), "clicked",
	G_CALLBACK (stop_clicked), NULL);
  gtk_box_pack_start (GTK_BOX (box), stop_button, TRUE, FALSE, 3);
  
  gtk_widget_show_all (box);
  
  return box;
}


GtkWidget *create_log_widget(void)
{
  GtkWidget *log_frame;
  GtkWidget *scrolled_window;
  GtkWidget *view;
  
  view = gtk_text_view_new (); /* Or use gtk_text_new () here instead ??? */
  log_buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));
  
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                  GTK_POLICY_AUTOMATIC,
                                  GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scrolled_window), view);
  
  log_frame = gtk_frame_new ("Log messages");
  gtk_container_add (GTK_CONTAINER (log_frame), scrolled_window);
  
  gtk_widget_show_all (log_frame);
  
  return log_frame;
}


/*
 * Every program needs a main, doesn't it? :-)
 */
gint main( gint   argc, gchar *argv[] )
{
    GtkWidget *window;          /* The main window */
    GtkWidget *box1;            
    GtkWidget *mms_url_widget;	/* for the MMS-url */
    GtkWidget *filename_widget;	/* for the filename */
    GtkWidget *buttons_widget;	/* for the 'Go!' and 'Stop!' button */
    GtkWidget *log_widget;      /* for displaying log messages */

    g_thread_init(NULL);
    gdk_threads_init();
    
    gtk_init (&argc, &argv);
    
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    g_signal_connect (G_OBJECT (window), "delete_event",
	  	      G_CALLBACK (delete_event), NULL);
    gtk_window_set_title (GTK_WINDOW (window),
			  "MMS download GUI by Bart Vandewoestyne");
    gtk_container_set_border_width (GTK_CONTAINER (window), 5);
    
    box1 = gtk_vbox_new (TRUE, 0);
    gtk_container_add (GTK_CONTAINER (window), box1);
    
    mms_url_widget = create_mms_url_widget();
    
    filename_widget = create_filename_widget();
    
    buttons_widget = create_buttons_widget();
    
    log_widget = create_log_widget();
    
    pbar = gtk_progress_bar_new ();
    //gtk_progress_bar_set_pulse_step (GTK_PROGRESS_BAR (pbar), 0.01);

    statusbar = gtk_statusbar_new();
    
    gtk_box_pack_start (GTK_BOX(box1), mms_url_widget, FALSE, FALSE, 1);
    gtk_box_pack_start (GTK_BOX(box1), filename_widget, FALSE, FALSE, 1);
    gtk_box_pack_start (GTK_BOX(box1), buttons_widget, FALSE, FALSE, 1);
    gtk_box_pack_start (GTK_BOX(box1), log_widget, FALSE, FALSE, 1);
    gtk_box_pack_start (GTK_BOX(box1), pbar, FALSE, FALSE, 1);
    //gtk_box_pack_start (GTK_BOX(box1), statusbar, FALSE, FALSE, 1);
    
    gtk_widget_show_all (window);

    gdk_threads_enter();
    gtk_main ();
    gdk_threads_leave();
    
    return 0;
}
