/* Copyright 2003 Bart Vandewoestyne <Bart.Vandewoestyne AT pandora.be>
 *
 *  This file is part of gmms.
 *
 *  Gmms is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Gmms is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Gmms; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>

#ifdef __unix__
#include <sys/socket.h>
#include <netdb.h>
#else
#include <io.h>
#include <winsock2.h>
#endif

#include "mms_lib.h"


/*
 * Put the 32-bit value (4 bytes) into a command buffer and increase
 * the number indicating the number of bytes of that command.  Mind
 * the endianness!!!
 */
void put_32 (command_t *cmd, guint32 value) {
  
  /* put last 8 bits of 'value' into cmd->num_bytes */
  cmd->buf[cmd->num_bytes  ] = value % 256;

  /* move 8 bits to the right, so we now have the following 8 bits */
  value = value >> 8;
  
  /* continue like this until all 32 bits are put in cmd->buf[...] */
  cmd->buf[cmd->num_bytes+1] = value % 256 ;
  value = value >> 8;
  cmd->buf[cmd->num_bytes+2] = value % 256 ;
  value = value >> 8;
  cmd->buf[cmd->num_bytes+3] = value % 256 ;

  cmd->num_bytes += 4;  // we've just added 4 more bytes...
}


/*
 * Get 32 bits (4 bytes) out of the specified buffer, starting at the
 * given offset.  Mind the endianness!!!
 */
guint32 get_32 (guchar *cmd, gint offset) {

  guint32 ret;  // we're gonna return 32 bits (4 bytes)

  ret = cmd[offset] ;
  ret |= cmd[offset+1]<<8 ;
  ret |= cmd[offset+2]<<16 ;
  ret |= cmd[offset+3]<<24 ;

  return ret;
}

/*
 * The MMS protocol has command packets and media packets. This routine
 * sends a command packet
 *      s:        the socket to send to
 *      command:  the MMS command
 *      switches: ???
 *      extra:    ???
 *      length:   ???
 *      data:     ???
 */
void send_command (gint s,
		   gint command,
		   guint32 switches,
		   guint32 extra,
		   gint length,
		   gchar *data) {
  
  command_t  cmd;
  gint        len8;
  gint        i;
  
  /* length in 8-bit bytes kinda rounded up???
     
  e.g:
  0 -> len8 = 0
  1 -> len8 = 0
  2 -> len8 = 0
  3 -> len8 = 0
  4 -> len8 = 0
  5 -> len8 = 1
  6 -> len8 = 1
  7 -> len8 = 1
  8 -> len8 = 1
  */
  len8 = (length + (length%8)) / 8;
  
  cmd.num_bytes = 0;  // we have not yet put commands into the buffer...

  /* Set up the MMS command packet header (40 bytes = 10 times 4 bytes).
     See MMS documentation.  Everything here is Big Endian
     cmd.num_bytes will be increased in each put_32 function call.       */
  
  put_32 (&cmd, 0x00000001);              // start sequence (4 bytes)
  put_32 (&cmd, 0xB00BFACE);              // the famous boobface #-)) (4 bytes)
  put_32 (&cmd, length + 32);             // length of the command in
					  // bytes until the end of
					  // all data (why +32 ???)
  
  put_32 (&cmd, 0x20534d4d);              // protocol type "MMS "
                                          // (see 'echo "MMS " | hexdump -C')
  put_32 (&cmd, len8 + 4);                // length until end of
                			  // packet in 8 byte boundary
                			  // lengths, including own
                			  // data field. E.g. for 8
                			  // bytes value = 1
  put_32 (&cmd, seq_num);                 // sequence number. starts
					  // from 0 and is echo'd back
					  // from server
  seq_num++;
  put_32 (&cmd, 0x0);                     // double precision
					  // timestamp (first part)
  put_32 (&cmd, 0x0);                     // double precision
					  // timestamp (second part)
  put_32 (&cmd, len8+2);                  // length until end of
			                  // packet in 8 byte boundary
			                  // lengths. Including own
			                  // data field. E.g. for 8
			                  // bytes value = 1
  put_32 (&cmd, 0x00030000 | command);    // direction of flow to
					  // server | command (see
					  // docs)
  
  /* We are now at the end of the 40 bytes command header.  It may be
     followed by additional information (see MMS docs) */
  put_32 (&cmd, switches);
  put_32 (&cmd, extra);
  
  /* copy the data after the header ??? */
  memcpy (&cmd.buf[48], data, length);
  
  /* The length of the data to send to the socket is now the length of
     the data (length) plus the 48 bytes of the command header??? */
#ifdef __unix__
  if (write (s, cmd.buf, length+48) != (length+48)) {
#else
    if (send (s, cmd.buf, length + 48, 0) != (length+48)) {
#endif
      g_print ("write error\n");
    }
  
    g_print ("\n***************************************************\ncommand sent, %d bytes\n", length+48);
    
    g_print ("start sequence %08x\n", get_32 (cmd.buf,  0));
    g_print ("command id     %08x\n", get_32 (cmd.buf,  4));
    g_print ("length         %8x \n", get_32 (cmd.buf,  8));
    g_print ("len8           %8x \n", get_32 (cmd.buf, 16));
    g_print ("sequence #     %08x\n", get_32 (cmd.buf, 20));
    g_print ("len8  (II)     %8x \n", get_32 (cmd.buf, 32));
    g_print ("dir | comm     %08x\n", get_32 (cmd.buf, 36));
    g_print ("switches       %08x\n", get_32 (cmd.buf, 40));
    
    g_print ("ascii contents>");
    for (i=48; i<(length+48); i+=2) { /* print content of data sent */
      guchar c = cmd.buf[i];
      
      if ((c>=32) && (c<=128))        /* print a character if it is one */
	g_print ("%c", c);
      else
	g_print (".");                /* put a dot if we do not have a
					 character */
    }
    g_print ("\n");
    
    g_print ("complete hexdump of package follows:\n");
    for (i=0; i<(length+48); i++) {
      guchar c = cmd.buf[i];
      
    g_print ("%02x", c);  /* print data */
    
    if ((i % 16) == 15)   /* put a newline after a while */
      g_print ("\n");
    
    if ((i % 2) == 1)     /* put space in between bytes */
      g_print (" ");
    
    }
    g_print ("\n");
    
  }
 
  
  /* Convert the string given by 'src' with length 'len' to Unicode UTF-16
     representation (see somewhere at http://www.unicode.org and
     http://www.ietf.org/rfc/rfc2781.txt )
     and put it in 'dest'.
     UTF-16 is described in the Unicode Standard, version 3.0 */
  void string_utf16(gchar *dest, gchar *src, gint len) {
    
    gint i;
    
    memset (dest, 0, 1000);  /* initialise dest to 1000 times 0 */
    
    for (i=0; i<len; i++) {
      dest[i*2] = src[i];
      dest[i*2+1] = 0;
    }
    
    /* padd with zeros */
    dest[i*2] = 0;
    dest[i*2+1] = 0;
  }
  

/* Print an answer we got back from the server.  Nothing is being written
   to a file here.  Function gives only informational output to the user. */
  void print_answer (gchar *data, int len) {
    
    gint i;
    
    g_print ("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\nanswer received, %d bytes\n", len);
    
    g_print ("start sequence %08x\n", get_32 (data, 0));
    g_print ("command id     %08x\n", get_32 (data, 4));
    g_print ("length         %8x \n", get_32 (data, 8));
    g_print ("len8           %8x \n", get_32 (data, 16));
    g_print ("sequence #     %08x\n", get_32 (data, 20));
    g_print ("len8  (II)     %8x \n", get_32 (data, 32));
    g_print ("dir | comm     %08x\n", get_32 (data, 36));
    g_print ("switches       %08x\n", get_32 (data, 40));
    
    for (i=48; i<len; i+=2) {     /* print data that follows */
      guchar c = data[i];
      
      if ((c>=32) && (c<128))     /* if it's a char, print it */
      g_print ("%c", c);
    else
      g_print (" %02x ", c);      /* if it's not a char, print the byte */
  }
  g_print ("\n");
}


/* get answer ??? */
  void get_answer (int s) {
  
  gchar  data[BUF_SIZE];
  gint   command = 0x1b;

  while (command == 0x1b) { // do this until we receive data without
			    // network timer test???

    int len;
    
#ifdef __unix__
    len = read (s, data, BUF_SIZE);           // read from socket
#else
    len = recv(s, data, BUF_SIZE, 0) ;        // read from socket
#endif
    if (!len) {
      printf ("\nalert! eof\n");              // we are at EOF
      return;
    }
    
    print_answer (data, len);                 // show answer
    
    command = get_32 (data, 36) & 0xFFFF;

    if (command == 0x1b)                      // check if we got a
					      // network timer test
      send_command (s, 0x1b, 0, 0, 0, data);  // answer 'we are still here!'
  }
}


/*
 * Gimme the data dude!
 */
gint get_data (int s, gchar *buf, guint count) {

  guint  len, total;

  total = 0;

  while (total < count) {  // while we don't have all data yet...

#ifdef __unix__
    len = read (s, &buf[total], count-total);   // receive the rest
                                                // for as much as we
                                                // can get
#else
    len = recv(s, &buf[total], count-total, 0); // receive the rest
                                                // for as much as we
                                                // can get
#endif
    if (len<0) {
      perror ("read error in get_data():");     // print error if
						// something went
						// wrong
      return 0;
    }

    total += len;                // increase the number indicating how
				 // much we've read

    if (len != 0) {
      printf ("[%d/%d]", total, count);        // print out how much
					       // we've read already
      fflush (stdout);
    }
    
  }

  return 1;

}


/*
 * Get header???
 */
gint get_header (gint s, guint8 *header) {
  
  guchar         pre_header[8];  /* pre-headers are 8 byte long and
                                    contain info like - packet
                                    sequence number - PacketIDType -
                                    UDP count / TCP flags - packet
                                    length
                                 */

  gint            i, header_len;
  
  header_len = 0;
  
  while (1) {
    
    if (!get_data (s, pre_header, 8)) {          // read 8 bytes of
						 // preheader info
      g_print ("pre-header read failed\n");
      return 0;
    }
    
    for (i=0; i<8; i++)
      g_print ("pre_header[%d] = %02x (%d)\n",    // print out all
						  // preheader info
	       i, pre_header[i], pre_header[i]);
    
    if (pre_header[4] == 0x02) {                  // check for PacketIDType ???
      
      gint packet_len;
      
      packet_len = (pre_header[7] << 8 | pre_header[6]) - 8; // minus
							     // 8 for
							     // the
							     // preheader
							     // ???
      
      g_print ("asf header packet detected, len=%d\n",
	       packet_len);
      
      if (!get_data (s, &header[header_len], packet_len)) {
	g_print ("header data read failed\n");
	return 0;
      }
      
      header_len += packet_len;
      
      if ( (header[header_len-1] == 1) && (header[header_len-2]==1)) {

	write (output_fh, header, header_len);
	
	 g_print ("get header packet finished\n");
	
	return (header_len);
	
      } 
      
    } else {
      
      gint packet_len, command;
      gchar data[BUF_SIZE];

      if (!get_data (s, (gchar *)&packet_len, 4)) {
	g_print ("packet_len read failed\n");
	return 0;
      }
      
      packet_len = get_32 ((gchar *)&packet_len, 0) + 4;
      
      g_print ("command packet detected, len=%d\n",
	       packet_len);
      
      if (!get_data (s, data, packet_len)) {
	g_print ("command data read failed\n");
	return 0;
      }
      
      command = get_32 (data, 24) & 0xFFFF;
      
      g_print ("command: %02x\n", command);
      
      if (command == 0x1b)                        // network timer request
	send_command (s, 0x1b, 0, 0, 0, data);    // answer 'we are still here!
      
    }
    
    g_print ("get header packet succ\n");
  }
}


gint interp_header (guint8 *header, gint header_len) {

  gint i;
  gint packet_length;
  
  /*
   * parse header
   */
  
  i = 30;
  while (i<header_len) {
    
    guint64  guid_1, guid_2, length;
    
    guid_2 = (guint64)header[i] | ((guint64)header[i+1]<<8) 
      | ((guint64)header[i+2]<<16) | ((guint64)header[i+3]<<24)
      | ((guint64)header[i+4]<<32) | ((guint64)header[i+5]<<40)
      | ((guint64)header[i+6]<<48) | ((guint64)header[i+7]<<56);
    i += 8;
    
    guid_1 = (guint64)header[i] | ((guint64)header[i+1]<<8) 
      | ((guint64)header[i+2]<<16) | ((guint64)header[i+3]<<24)
      | ((guint64)header[i+4]<<32) | ((guint64)header[i+5]<<40)
      | ((guint64)header[i+6]<<48) | ((guint64)header[i+7]<<56);
    i += 8;
    
    g_print ("guid found: %016llx%016llx\n", guid_1, guid_2);
    
    length = (guint64)header[i] | ((guint64)header[i+1]<<8) 
      | ((guint64)header[i+2]<<16) | ((guint64)header[i+3]<<24)
      | ((guint64)header[i+4]<<32) | ((guint64)header[i+5]<<40)
      | ((guint64)header[i+6]<<48) | ((guint64)header[i+7]<<56);
    
    i += 8;
    
    if ( (guid_1 == 0x6cce6200aa00d9a6) && (guid_2 == 0x11cf668e75b22630) ) {
      g_print ("header object\n");
    } else if ((guid_1 == 0x6cce6200aa00d9a6) && (guid_2 == 0x11cf668e75b22636)) {
      g_print ("data object\n");
    } else if ((guid_1 == 0x6553200cc000e48e) && (guid_2 == 0x11cfa9478cabdca1)) {
      
      packet_length = get_32(header, i+92-24);
      
      g_print ("file object, packet length = %d (%d)\n",
	       packet_length, get_32(header, i+96-24));
      
      
    } else if ((guid_1 == 0x6553200cc000e68e)
	       && (guid_2 == 0x11cfa9b7b7dc0791)) {
      
      gint stream_id = header[i+48] | header[i+49] << 8;
      
      g_print ("stream object, stream id: %d\n", stream_id);
      
      stream_ids[num_stream_ids] = stream_id;
      num_stream_ids++;
      
      
      /*
	} else if ((guid_1 == 0x) && (guid_2 == 0x)) {
	g_print ("??? object\n");
      */
    } else {
      g_print ("unknown object\n");
    }
    
    g_print ("length    : %lld\n", length);

    i += length-24;
    
  }
  
  return packet_length;
  
}


/*
 * Get the real media packets, using this routine starts writing
 * to the file, jeehaa!
 */
gint get_media_packet (gint s, gint padding) {
  
  guchar         pre_header[8];
  gint            i;
  gchar           data[BUF_SIZE];
  
  /* first read the pre-header info from the MMS protocol */
  if (!get_data (s, pre_header, 8)) {
    g_print ("pre-header read failed\n");
    return 0;
  }

  for (i=0; i<8; i++)
    g_print ("pre_header[%d] = %02x (%d)\n",
	     i, pre_header[i], pre_header[i]);
  
  if (pre_header[4] == 0x04) {  // pre-header tells us what we get:
				// media or length???
    
    gint packet_len;
    
    packet_len = (pre_header[7] << 8 | pre_header[6]) - 8;
    
    g_print ("asf media packet detected, len=%d\n",
	     packet_len);
    
    if (!get_data (s, data, packet_len)) {
      g_print ("media data read failed\n");
      return 0;
    }
    
    /* if no errors occured when reading media packet, write it to the
       file */
    write (output_fh, data, padding);
    
  } else {
    
    gint packet_len, command;
    
    if (!get_data (s, (gchar *)&packet_len, 4)) {
      g_print ("packet_len read failed\n");
      return 0;
    }
    
    packet_len = get_32 ((gchar *)&packet_len, 0) + 4;
    
    g_print ("command packet detected, len=%d\n",
	     packet_len);
    
    if (!get_data (s, data, packet_len)) {
      g_print ("command data read failed\n");
      return 0;
    }
    
    if ( (pre_header[7] != 0xb0) || (pre_header[6] != 0x0b)
	 || (pre_header[5] != 0xfa) || (pre_header[4] != 0xce) ) {
      
      g_print ("missing signature\n");
      exit (1);
      
    }
    
    command = get_32 (data, 24) & 0xFFFF;
    
    g_print ("command: %02x\n", command);
    
    if (command == 0x1b) 
      send_command (s, 0x1b, 0, 0, 0, data);
    else if (command == 0x1e) {
      
      g_print ("everything done. Thank you for downloading a media file containing proprietary and patentend technology.\n");
      
      return 0;
    } else if (command != 0x05) {
      g_print ("unknown command %02x\n", command);
      exit (1);
    }
  }
  
  g_print ("get media packet succ\n");
  
  return 1;
}


void get_mms_stream (gchar *url, gchar *filename) {

#ifndef __unix__
  WORD wVersionRequested;      /* Needed for WSAStartup() */
  WSADATA wsaData;             /* Needed for WSAStartup() */
  int err;                     /* socket startup error code */
#endif

  gint s ;                     /* for error code of socket opening */
  struct sockaddr_in    sa;    /* ??? */
  struct hostent        *hp;   /* data structure with host information */
  gchar str[1024];             /* ??? */
  gchar data[BUF_SIZE];        /* ??? (this was initially 1024 in
					size... not BUF_SIZE) */
  guint8 asf_header[8192];     /* ??? */
  gint asf_header_len;         /* ??? */
  gint len, i, packet_length;  /* ??? */
  gchar host[256];             /* the host name without mms: and the
				      path to the file */
  gchar *path;                 /* the complete path to the file */ 
  gchar *file;                 /* the name of the single file without
				  the complete path */
  gchar *cp;                   /* ??? */
  //  static GMutex *stop_mutex = NULL;  // do we really need it???

  
#ifndef __unix__
    /* Need to startup Winsocket stuff first... */
    wVersionRequested = MAKEWORD( 2, 2 );
    err = WSAStartup( wVersionRequested, &wsaData );
    if ( err != 0 ) {
        /* Tell the user that we could not find a usable */
        /* WinSock DLL.                                  */
        perror("An error occured at WSAStartup() function!\n");
        return;
    }
#endif

  /* parse url */
  g_strlcpy (host, &url[6], 255);
  cp = strchr(host,'/');
  *cp= 0;  // Note: isn't this strange, we never use this???
  g_print ("host : >%s<\n", host);

  path = strchr(&url[6], '/') +1;
  g_print ("path : >%s<\n", path);

  file = filename;
  g_print ("file : >%s<\n", file);
  
  /* Windows needs O_BINARY here!!!  Fuckin' searched quite long for
     this 'bug'... */
#ifdef __unix__
  output_fh = open (file, O_WRONLY | O_CREAT | O_TRUNC, 0644);
#else
  output_fh = open(file, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0644);
#endif
  if (output_fh<0) { g_error("cannot create output file '%s'.\n", file); }
  
  g_print ("Creating output file '%s'\n", &file[1]);
  
  /* DNS lookup */
  
  if ((hp = gethostbyname(host)) == NULL) {
    g_error("Host name lookup failure!\n");
  }

  /* fill socket structure */
  
#ifdef __unix__
  bcopy ((char *) hp->h_addr, (char *) &sa.sin_addr, hp->h_length);
#else
  memcpy((char *) &sa.sin_addr, (char *) hp->h_addr, hp->h_length);
#endif
  sa.sin_family = hp->h_addrtype;
  /*sa.sin_port = 0x5000;*/ /* http port (80 => 50 Hex, switch Hi-/Lo-Word ) */
  
  sa.sin_port = htons(1755) ; /* be2me_16(1755);  mms port 1755 */

  g_print ("Port: %08x\n", sa.sin_port);
  
  /* open socket */

  if ((s = socket(hp->h_addrtype, SOCK_STREAM, 0))<0) {
    g_error ("Error opening socket!");
  }

  g_print ("socket open\n");
  
  /* try to connect */
  
  if (connect (s, (struct sockaddr *)&sa, sizeof sa)<0) {
    g_error ("Error while trying to connect to socket!");
  }

  g_print ("Connected\n");
  

  /* cmd1 */
  
  sprintf (str, "\034\003NSPlayer/7.0.0.1956; {33715801-BAB3-9D85-24E9-03B90328270A}; Host: %s",
	   host);
  string_utf16 (data, str, strlen(str)+2);  /* make it UTF16 encoding */
  
  /* send command '1' (see MMS docs) with switch '0' and extra '0x0004000b' */
  send_command (s, 1, 0, 0x0004000b, strlen(str) * 2+8, data);
  
  /* read back and print answer */
#ifdef __unix__
  len = read (s, data, BUF_SIZE) ;
#else
  len = recv(s, data, BUF_SIZE, 0) ;
  printf("error = %d\n", WSAGetLastError());
#endif
  if (len)
    print_answer (data, len);

  /* Send second command (02) to server.  We are sending:
     - transport protocol
     - client IP address
     - client socket port
     Question: why do we send 192.168.0.129 ???
  */
  
  string_utf16 (&data[8], "\002\000\\\\192.168.0.129\\TCP\\1037\0000",
                28);
  memset (data, 0, 8);
  send_command (s, 2, 0, 0, 28*2+8, data);
  
  /* read back answer from server */
#ifdef __unix__
  len = read (s, data, BUF_SIZE);
#else
  len = recv(s, data, BUF_SIZE, 0) ;
  printf("error = %d\n", WSAGetLastError());
#endif
  if (len)
    print_answer (data, len);

  
  /* Send 0x5 command to server, this includes:
     - file path (at server)
     - file name
  */
  string_utf16 (&data[8], path, strlen(path));  /* convert to UTF 16 */
  memset (data, 0, 8);
  
  /* send command '5' with switch '0' and extra '0' */
  send_command (s, 5, 0, 0, strlen(path)*2+12, data);

  /* read back answer */
  get_answer (s);


  /* Send a 0x15 header request which includes a Packet ID type value
     used by the server when sending header type MMS pre headers */ 
  memset (data, 0, 40);
  data[32] = 2; // header packet ID type ???
  
  /* mind the switch is at 1 here! */
  send_command (s, 0x15, 1, 0, 40, data);
  
  num_stream_ids = 0;
  
  /* read the header info we got after our previous request ??? */
  asf_header_len = get_header (s, asf_header);
  packet_length = interp_header (asf_header, asf_header_len);

  
  /* Send the 0x33 command */
  
  memset (data, 0, 40);
  
  for (i=1; i<num_stream_ids; i++) {
    data [ (i-1) * 6 + 2 ] = 0xFF;
    data [ (i-1) * 6 + 3 ] = 0xFF;
    data [ (i-1) * 6 + 4 ] = stream_ids[i];
    data [ (i-1) * 6 + 5 ] = 0x00;
  }
  
  send_command (s, 0x33, num_stream_ids,
                0xFFFF | stream_ids[0] << 16,
                (num_stream_ids-1)*6+2 , data);
  
  get_answer (s);

  
  /* Send the 0x07 command ('start streaming from packet xx') */
  memset (data, 0, 40);
  
  for (i=8; i<16; i++)
    data[i] = 0xFF;
  
  data[20] = 0x04;
  
  send_command (s, 0x07, 1,
                0xFFFF | stream_ids[0] << 16,
                24, data);
  
  /* read media packets until stop pressed??? */
  while (!stopped) {
    
    get_media_packet(s, packet_length);  
    gdk_threads_enter();
    g_message("PULSING BAR!!!");
    gtk_progress_bar_pulse (GTK_PROGRESS_BAR (pbar));
    gdk_threads_leave();

    // Do i really need the mutex stuff here???  Seems to work
    // without it... and doesn't seem to do much harm like this...
    
    //if (!stop_mutex)
    //  stop_mutex = g_mutex_new ();
    
    //g_mutex_lock(stop_mutex);
    if (stopped) {
      close (output_fh);
      close (s);
    }
    //g_mutex_unlock(stop_mutex);
    
  }
  
}
