/* Copyright 2003 Bart Vandewoestyne <Bart.Vandewoestyne AT pandora.be>
 *
 *  This file is part of gmms.
 *
 *  Gmms is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Gmms is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Gmms; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MMS_LIB_H
#define MMS_LIB_H


#define BUF_SIZE 102400  // Is this correct?  Shouldn't it be 1024 ???

/* the structure defining an MMS command and it's size in bytes */

typedef struct {

  guint8	buf[BUF_SIZE];  /* the buffer containing the commands */
  gint		num_bytes;      /* the number of bytes in the command */

} command_t;

gint seq_num;                     /* the sequence number of this command */
gint num_stream_ids;              /* the number of different stream id's??? */
gint stream_ids[20];              /* ??? */
int output_fh;                    /* a handle to the the output file */
extern gboolean stopped;          /* flag indicating if stop button is
				                     pressed */
extern GtkTextBuffer *log_buffer; /* the text buffer for log messages */
extern GtkWidget *pbar;           /* the progress bar */

void put_32 (command_t *cmd,
	     guint32 value);

guint32 get_32 (guchar *cmd,
		gint offset);

void send_command (gint s,
		   gint command,
		   guint32 switches,
		   guint32 extra,
		   gint length,
		   gchar *data);

void string_utf16(gchar *dest,
		  gchar *src,
		  gint len);

void print_answer (gchar *data,
		   int len);

void get_answer (gint s);

int get_data (gint s,
	      gchar *buf,
	      guint count);

int get_header (gint s,
		guint8 *header);

gint interp_header (guint8 *header,
		    gint header_len);

gint get_media_packet (gint s,
		       gint padding);

void get_mms_stream (gchar *url,
		     gchar *filename);

#endif
