#include "assistant.h"
#include "midi.h"
#include "settings.h"
#include "timidity.h"
#include "timiditylauncher.h"

Assistant::Assistant(TSE3::MidiSchedulerFactory& midiFactory, QWidget* parent, char* name)
: QWizard(parent, name, true),
  scheduler(0),
  launcher(0),
  factory(midiFactory)
{
	launcher = new TimidityLauncher();
	
	setupIntro();
	setupTimidity();
	setupTSE3();
	
	connect(finishButton(), SIGNAL(clicked()), SLOT(finish()));
	connect(cancelButton(), SIGNAL(clicked()), SLOT(finish()));
}

Assistant::~Assistant()
{
}

void Assistant::showPage(QWidget* widget)
{
	if (widget == page[2]) {
		if (launcher->isRunning())
			launcher->kill();
		
		if (timidity->isTimidityWanted()) {
			timidity->buildCmdLine(*launcher);
			
			if (launcher->launchTimidity() == false)
				KMessageBox::error(0, "Couldn't launch timidity " + launcher->errorMsg());
		}
	}
	
	QWizard::showPage(widget);
}

TimidityLauncher* Assistant::timidityLauncher()
{
	return launcher;
}

TSE3::MidiScheduler* Assistant::midiScheduler() const
{
	return scheduler;
}

void Assistant::cancel()
{
	if (launcher->isRunning())
		launcher->kill();
	
	if (scheduler) {
		delete scheduler;
		
		scheduler = 0;
	}
}

void Assistant::finish()
{
	// Write config
	//
	timidity->writeConfig();
	
	midi->writeConfig();
	
	Settings::config->setGroup("Assistant");
	Settings::config->writeEntry("FirstTime", true);
}

void Assistant::setupIntro()
{
	page[0] = new QHBox(this);
	
	QLabel* introduction = new QLabel(page[0]);
	
	introduction->setMargin(11);
	introduction->setText("With this wizard you can configure\n"
						  "your midi driver\n(hardware or software\n"
						  "with timidity).");
	introduction->setMaximumWidth(introduction->sizeHint().width());
	
	addPage(page[0], "Introduction");
}

void Assistant::setupTimidity()
{
	page[1] = new QHBox(this);
	
	QLabel* introduction = new QLabel(page[1]);
	
	introduction->setMargin(11);
	introduction->setText("Timidty is a MIDI-to-WAVE converter\n"
						  "but you can use this program as software\n"
						  "synthetiser.\n"
						  "TiMidity works purely as the software\n"
						  "real-time MIDI render, that is as a\n"
						  "software MIDI synth engine on ALSA.");
	introduction->setMaximumWidth(introduction->sizeHint().width());
	
	timidity = new Timidity(page[1]);
	
	addPage(page[1], "Timidity");
}

void Assistant::setupTSE3()
{
	page[2] = new QHBox(this);
	
	QLabel* introduction = new QLabel(page[2]);
	
	introduction->setMargin(11);
	introduction->setText("With this wizard you can configure your midi driver\n(hardware or software with timidity).");
	introduction->setMaximumWidth(introduction->sizeHint().width());
	
	midi = new Tse3Assistant(factory, page[2], "MidiWidget");
	
	addPage(page[2], "TSE3");
	setFinishEnabled(page[2], true);
}
