/***************************************************************************
 * assistant.h: implementation of Assistant class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef ASSISTANT_H
#define ASSISTANT_H

#include <header.h>

class Timidity;
class TimidityLauncher;
class Tse3Assistant;

class Assistant: public QWizard {
	Q_OBJECT
public:
	Assistant(TSE3::MidiSchedulerFactory& midiFactory, QWidget* parent = 0, char* name = 0);
	~Assistant();
	
	virtual void showPage(QWidget* widget);
	
	TimidityLauncher* timidityLauncher();
	TSE3::MidiScheduler* midiScheduler() const;
private slots:
	void cancel();
	void finish();
	
private:
	void setupIntro();
	void setupTimidity();
	void setupTSE3();
	
	QHBox* page[3];
	TSE3::MidiScheduler* scheduler;
	TimidityLauncher* launcher;
	Timidity* timidity;
	Tse3Assistant* midi;
	TSE3::MidiSchedulerFactory& factory;
};

#endif
