/***************************************************************************
 * midi.cpp: implementation of Tse3 class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "midi.h"
#include "settings.h"

Tse3Assistant::Tse3Assistant(TSE3::MidiSchedulerFactory& midiFactory, QWidget* parent, const char* name)
: QWidget(parent, name),
  midiport(this),
  midiportLabel(&midiport, i18n("MIDI &output port"), this),
  midiRefresh(i18n("&Refresh"), this),
  midiLayout(this, 10, 5),
  midiButton(this),
  scheduler(0),
  factory(midiFactory)
{
	midiport.setSorting(-1);
	midiport.setFrameStyle(QFrame::Panel | QFrame::Sunken);
	midiport.addColumn(i18n("Name"));
	midiport.addColumn(i18n("Port"));
	midiport.addColumn(i18n("Port Number"));
	midiport.addColumn(i18n("is Readable"));
	midiport.addColumn(i18n("is Writeable"));
	
	fillTse3Box();
	
	connect(&midiRefresh, SIGNAL(clicked()), SLOT(fillTse3Box()));
	
	midiButton.addWidget(&midiRefresh);
	
	// Set widget layout
	//
	midiLayout.addWidget(&midiportLabel);
	midiLayout.addWidget(&midiport, 1);
	midiLayout.addLayout(&midiButton);
	midiLayout.activate();
}

void Tse3Assistant::fillTse3Box()
{
	QString temp, read, write;
	QListViewItem* lastItem = NULL;
	
	midiport.clear();
	
	if (scheduler) {
		delete scheduler;
	}
	
	try {
		scheduler = factory.createScheduler();
	} catch (TSE3::MidiSchedulerError e) {
		QString temp = e.what();
		
		kdDebug() << "error while creating the midi scheduler !!\n" << temp << "\n";
		KMessageBox::error(0, "Couldn't create a MidiScheduler for this platform " + temp);
		
		scheduler = 0;
		
		return ;
	}

	scheduler->portNumbers(portNums);
	
	for (uint i = 0; i < scheduler->numPorts(); i++) {
		if (scheduler->portReadable(portNums[i]))
			read = "Yes";
		else
			read = "No";
		
		if (scheduler->portWriteable(portNums[i]))
			write = "Yes";
		else
			write = "No";
		
		lastItem = new QListViewItem(&midiport, lastItem, scheduler->portName(portNums[i]), scheduler->portType(portNums[i]), temp.setNum(portNums[i]), read, write);
		
		// Select the current midi card
		//
		if (portNums[i] == Settings::midiPortNumber()) {
			midiport.setCurrentItem(lastItem);
		}
	}
}

void Tse3Assistant::writeConfig()
{
	Settings::config->setGroup("MIDI");
	
	if (midiport.isSelected(midiport.currentItem())) {
		Settings::config->writeEntry("Name", midiport.currentItem()->text(0));
		Settings::config->writeEntry("Port", midiport.currentItem()->text(1));
		Settings::config->writeEntry("PortNumber", midiport.currentItem()->text(2));
		Settings::config->writeEntry("Readable", midiport.currentItem()->text(3));
		Settings::config->writeEntry("Writeable", midiport.currentItem()->text(4));
	}
}
