/***************************************************************************
 * midi.h: implementation of Midi class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef MIDI_H
#define MIDI_H

#include <header.h>

class Tse3Assistant: public QWidget {
	Q_OBJECT
public:
	Tse3Assistant(TSE3::MidiSchedulerFactory& midiFactory, QWidget* parent = 0, const char* name = 0);
	
	virtual void writeConfig();
	
private slots:
	void fillTse3Box();
	
private:
	QListView midiport;
	QLabel midiportLabel;
	QPushButton midiRefresh;
	QVBoxLayout midiLayout;
	QHBoxLayout midiButton;
	
	std::vector<int> portNums;
	TSE3::MidiScheduler* scheduler;
	
	TSE3::MidiSchedulerFactory& factory;
};

#endif
